/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_SessionEnvironment();


void
init_SessionEnvironment(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SessionEnvironment"),
		get_func_prim(xl_SessionEnvironment,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_SessionEnvironment(XLISP_ENV * env,XL_SEXP * s)
{
int ret;
XL_SEXP * id;
	id = get_el(s,1);
	if ( get_type(id) != XLT_INTEGER )
		goto type_missmatch;
	ret = set_initial_sexp(id->integer.data,env,get_el(s,2));
	if ( ret < 0 ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_EXEC_ERROR,
			l_string(std_cm,"SetAessionEnv"),
			get_integer(ret,0));
	}
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SessionEnvironment"),
		n_get_string("type missmatch"));
}


