/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"utils.h"
#include	"long_char.h"

void
wct_unicode(WCT * w)
{
WRITABLE_CODE_TABLE * uni, * t;
char * locale;
	uni = get_wct(w,0);
	if ( uni == 0 )
		uni = set_wct(w,0,LCZM_2B_TYPE,0,0);
	locale = get_locale();
	if ( strcmp(locale,"jp") == 0 ) {
		t = get_wct(w,LCZ_2BC_UNICODE_v3_0_JP);
		if ( t )
			copy_wct(uni,t,SC_IF_NOTEXIST);
	}
	else if ( strcmp(locale,"tw") == 0 ) {
		t = get_wct(w,LCZ_2BC_UNICODE_v3_0_TW);
		if ( t )
			copy_wct(uni,t,SC_IF_NOTEXIST);
	}
	else if ( strcmp(locale,"cn") == 0 ) {
		t = get_wct(w,LCZ_2BC_UNICODE_v3_0_CN);
		if ( t )
			copy_wct(uni,t,SC_IF_NOTEXIST);
	}
	else if ( strcmp(locale,"kr") == 0 || strcmp(locale,"kp") == 0 ) {
		t = get_wct(w,LCZ_2BC_UNICODE_v3_0_KR);
		if ( t )
			copy_wct(uni,t,SC_IF_NOTEXIST);
	}
	t = get_wct(w,LCZ_2BC_UNICODE_v3_0_JP);
	if ( t )
		copy_wct(uni,t,SC_IF_NOTEXIST);
	t = get_wct(w,LCZ_2BC_UNICODE_v3_0_TW);
	if ( t )
		copy_wct(uni,t,SC_IF_NOTEXIST);
	t = get_wct(w,LCZ_2BC_UNICODE_v3_0_CN);
	if ( t )
		copy_wct(uni,t,SC_IF_NOTEXIST);
	t = get_wct(w,LCZ_2BC_UNICODE_v3_0_KR);
	if ( t )
		copy_wct(uni,t,SC_IF_NOTEXIST);
}
