/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.messages;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sbbi.upnp.messages.ActionMessageResponseParser;
import net.sbbi.upnp.messages.ActionResponse;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.ISO8601Date;
import net.sbbi.upnp.services.ServiceAction;
import net.sbbi.upnp.services.ServiceActionArgument;
import net.sbbi.upnp.services.ServiceStateVariable;
import net.sbbi.upnp.services.UPNPService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ActionMessage {
    private static final Log log = LogFactory.getLog(ActionMessage.class);
    private UPNPService service;
    private ServiceAction serviceAction;
    private List inputParameters;

    protected ActionMessage(UPNPService service, ServiceAction serviceAction) {
        this.service = service;
        this.serviceAction = serviceAction;
        if (serviceAction.getInputActionArguments() != null) {
            this.inputParameters = new ArrayList();
        }
    }

    public void clearInputParameters() {
        this.inputParameters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionResponse service() throws IOException, UPNPResponseException {
        ActionResponse rtrVal = null;
        UPNPResponseException upnpEx = null;
        IOException ioEx = null;
        StringBuffer body = new StringBuffer(256);
        body.append("<?xml version=\"1.0\"?>\r\n");
        body.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        body.append(" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        body.append("<s:Body>");
        body.append("<u:").append(this.serviceAction.getName()).append(" xmlns:u=\"").append(this.service.getServiceType()).append("\">");
        if (this.serviceAction.getInputActionArguments() != null) {
            Iterator itr = this.inputParameters.iterator();
            while (itr.hasNext()) {
                InputParamContainer container = (InputParamContainer)itr.next();
                body.append("<").append(container.name).append(">").append(container.value);
                body.append("</").append(container.name).append(">");
            }
        }
        body.append("</u:").append(this.serviceAction.getName()).append(">");
        body.append("</s:Body>");
        body.append("</s:Envelope>");
        if (log.isDebugEnabled()) {
            log.debug("POST prepared for URL " + this.service.getControlURL());
        }
        URL url = new URL(this.service.getControlURL().toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        HttpURLConnection.setFollowRedirects(false);
        conn.setRequestProperty("HOST", url.getHost() + ":" + url.getPort());
        conn.setRequestProperty("CONTENT-TYPE", "text/xml; charset=\"utf-8\"");
        conn.setRequestProperty("CONTENT-LENGTH", Integer.toString(body.length()));
        conn.setRequestProperty("SOAPACTION", "\"" + this.service.getServiceType() + "#" + this.serviceAction.getName() + "\"");
        OutputStream out = conn.getOutputStream();
        out.write(body.toString().getBytes());
        out.flush();
        out.close();
        conn.connect();
        InputStream input = null;
        if (log.isDebugEnabled()) {
            log.debug("executing query :\n" + body);
        }
        try {
            input = conn.getInputStream();
        }
        catch (IOException ex) {
            input = conn.getErrorStream();
        }
        if (input != null) {
            int response = conn.getResponseCode();
            String responseBody = this.getResponseBody(input);
            if (log.isDebugEnabled()) {
                log.debug("received response :\n" + responseBody);
            }
            SAXParserFactory saxParFact = SAXParserFactory.newInstance();
            saxParFact.setValidating(false);
            saxParFact.setNamespaceAware(true);
            ActionMessageResponseParser msgParser = new ActionMessageResponseParser(this.serviceAction);
            StringReader stringReader = new StringReader(responseBody);
            InputSource src = new InputSource(stringReader);
            try {
                SAXParser parser = saxParFact.newSAXParser();
                parser.parse(src, (DefaultHandler)msgParser);
            }
            catch (ParserConfigurationException confEx) {
                throw new RuntimeException("ParserConfigurationException during SAX parser creation, please check your env settings:" + confEx.getMessage());
            }
            catch (SAXException saxEx) {
                upnpEx = new UPNPResponseException(899, saxEx.getMessage());
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException ex) {}
            }
            if (upnpEx == null) {
                if (response == 200) {
                    rtrVal = msgParser.getActionResponse();
                } else if (response == 500) {
                    upnpEx = msgParser.getUPNPResponseException();
                } else {
                    ioEx = new IOException("Unexpected server HTTP response:" + response);
                }
            }
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        conn.disconnect();
        if (upnpEx != null) {
            throw upnpEx;
        }
        if (rtrVal == null && ioEx == null) {
            ioEx = new IOException("Unable to receive a response from the UPNP device");
        }
        if (ioEx != null) {
            throw ioEx;
        }
        return rtrVal;
    }

    private String getResponseBody(InputStream in) throws IOException {
        byte[] buffer = new byte[256];
        int readen = 0;
        StringBuffer content = new StringBuffer(256);
        while ((readen = in.read(buffer)) != -1) {
            content.append(new String(buffer, 0, readen));
        }
        int len = content.length();
        while (content.charAt(len - 1) == '\u0000') {
            content.setLength(--len);
        }
        return content.toString().trim();
    }

    public List getInputParameterNames() {
        return this.serviceAction.getInputActionArgumentsNames();
    }

    public List getOutputParameterNames() {
        return this.serviceAction.getOutputActionArgumentsNames();
    }

    public ActionMessage setInputParameter(String parameterName, Object parameterValue) throws IllegalArgumentException {
        if (parameterValue == null) {
            return this.setInputParameter(parameterName, "");
        }
        if (parameterValue instanceof Date) {
            return this.setInputParameter(parameterName, (Date)parameterValue);
        }
        if (parameterValue instanceof Boolean) {
            return this.setInputParameter(parameterName, (Boolean)parameterValue);
        }
        if (parameterValue instanceof Integer) {
            return this.setInputParameter(parameterName, (Integer)parameterValue);
        }
        if (parameterValue instanceof Byte) {
            return this.setInputParameter(parameterName, (Byte)parameterValue);
        }
        if (parameterValue instanceof Short) {
            return this.setInputParameter(parameterName, (Short)parameterValue);
        }
        if (parameterValue instanceof Float) {
            return this.setInputParameter(parameterName, ((Float)parameterValue).floatValue());
        }
        if (parameterValue instanceof Double) {
            return this.setInputParameter(parameterName, (Double)parameterValue);
        }
        if (parameterValue instanceof Long) {
            return this.setInputParameter(parameterName, (Long)parameterValue);
        }
        return this.setInputParameter(parameterName, parameterValue.toString());
    }

    public ActionMessage setInputParameter(String parameterName, String parameterValue) throws IllegalArgumentException {
        if (this.serviceAction.getInputActionArguments() == null) {
            throw new IllegalArgumentException("No input parameters required for this message");
        }
        ServiceActionArgument arg = this.serviceAction.getInputActionArgument(parameterName);
        if (arg == null) {
            throw new IllegalArgumentException("Wrong input argument name for this action:" + parameterName + " available parameters are : " + this.getInputParameterNames());
        }
        Iterator i = this.inputParameters.iterator();
        while (i.hasNext()) {
            InputParamContainer container = (InputParamContainer)i.next();
            if (!container.name.equals(parameterName)) continue;
            container.value = parameterValue;
            return this;
        }
        InputParamContainer container = new InputParamContainer();
        container.name = parameterName;
        container.value = parameterValue;
        this.inputParameters.add(container);
        return this;
    }

    public ActionMessage setInputParameter(String parameterName, Date parameterValue) throws IllegalArgumentException {
        if (this.serviceAction.getInputActionArguments() == null) {
            throw new IllegalArgumentException("No input parameters required for this message");
        }
        ServiceActionArgument arg = this.serviceAction.getInputActionArgument(parameterName);
        if (arg == null) {
            throw new IllegalArgumentException("Wrong input argument name for this action:" + parameterName + " available parameters are : " + this.getInputParameterNames());
        }
        ServiceStateVariable linkedVar = arg.getRelatedStateVariable();
        if (linkedVar.getDataType().equals("time")) {
            return this.setInputParameter(parameterName, ISO8601Date.getIsoTime(parameterValue));
        }
        if (linkedVar.getDataType().equals("time.tz")) {
            return this.setInputParameter(parameterName, ISO8601Date.getIsoTimeZone(parameterValue));
        }
        if (linkedVar.getDataType().equals("date")) {
            return this.setInputParameter(parameterName, ISO8601Date.getIsoDate(parameterValue));
        }
        if (linkedVar.getDataType().equals("dateTime")) {
            return this.setInputParameter(parameterName, ISO8601Date.getIsoDateTime(parameterValue));
        }
        if (linkedVar.getDataType().equals("dateTime.tz")) {
            return this.setInputParameter(parameterName, ISO8601Date.getIsoDateTimeZone(parameterValue));
        }
        throw new IllegalArgumentException("Related input state variable " + linkedVar.getName() + " is not of an date type");
    }

    public ActionMessage setInputParameter(String parameterName, boolean parameterValue) throws IllegalArgumentException {
        return this.setInputParameter(parameterName, parameterValue ? "1" : "0");
    }

    public ActionMessage setInputParameter(String parameterName, byte parameterValue) throws IllegalArgumentException {
        return this.setInputParameter(parameterName, Byte.toString(parameterValue));
    }

    public ActionMessage setInputParameter(String parameterName, short parameterValue) throws IllegalArgumentException {
        return this.setInputParameter(parameterName, Short.toString(parameterValue));
    }

    public ActionMessage setInputParameter(String parameterName, int parameterValue) throws IllegalArgumentException {
        return this.setInputParameter(parameterName, Integer.toString(parameterValue));
    }

    public ActionMessage setInputParameter(String parameterName, long parameterValue) throws IllegalArgumentException {
        return this.setInputParameter(parameterName, Long.toString(parameterValue));
    }

    public ActionMessage setInputParameter(String parameterName, float parameterValue) throws IllegalArgumentException {
        return this.setInputParameter(parameterName, Float.toString(parameterValue));
    }

    public ActionMessage setInputParameter(String parameterName, double parameterValue) throws IllegalArgumentException {
        return this.setInputParameter(parameterName, Double.toString(parameterValue));
    }

    private class InputParamContainer {
        private String name;
        private String value;

        private InputParamContainer() {
        }
    }
}

