/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import mx4j.tools.adaptor.http.CommandProcessorUtil;
import mx4j.tools.adaptor.http.HttpCommandProcessorAdaptor;
import mx4j.tools.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InvokeOperationCommandProcessor
extends HttpCommandProcessorAdaptor {
    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document;
        block24: {
            ObjectName name;
            Element operationElement;
            block25: {
                boolean match;
                ArrayList<Object> values;
                ArrayList<String> types;
                String operationVariable;
                block26: {
                    document = this.builder.newDocument();
                    Element root = document.createElement("MBeanOperation");
                    document.appendChild(root);
                    operationElement = document.createElement("Operation");
                    operationElement.setAttribute("operation", "invoke");
                    root.appendChild(operationElement);
                    String objectVariable = in.getVariable("objectname");
                    operationVariable = in.getVariable("operation");
                    if (objectVariable == null || objectVariable.equals("") || operationVariable == null || operationVariable.equals("")) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", "Incorrect parameters in the request");
                        return document;
                    }
                    operationElement.setAttribute("objectname", objectVariable);
                    types = new ArrayList<String>();
                    values = new ArrayList<Object>();
                    int i = 0;
                    boolean unmatchedParameters = false;
                    boolean valid = false;
                    do {
                        String parameterType = in.getVariable("type" + i);
                        String parameterValue = in.getVariable("value" + i);
                        boolean bl = valid = parameterType != null && parameterValue != null;
                        if (valid) {
                            types.add(parameterType);
                            Object value = null;
                            try {
                                value = CommandProcessorUtil.createParameterValue(parameterType, parameterValue);
                            }
                            catch (Exception e) {
                                operationElement.setAttribute("result", "error");
                                operationElement.setAttribute("errorMsg", "Parameter " + i + ": " + parameterValue + " cannot be converted to type " + parameterType);
                                return document;
                            }
                            if (value != null) {
                                values.add(value);
                            }
                        }
                        if (parameterType == null ^ parameterValue == null) {
                            unmatchedParameters = true;
                            break;
                        }
                        ++i;
                    } while (valid);
                    if (objectVariable == null || objectVariable.equals("") || operationVariable == null || operationVariable.equals("")) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", "Incorrect parameters in the request");
                        return document;
                    }
                    if (unmatchedParameters) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", "count of parameter types doesn't match count of parameter values");
                        return document;
                    }
                    name = null;
                    try {
                        name = new ObjectName(objectVariable);
                    }
                    catch (MalformedObjectNameException e) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", "Malformed object name");
                        return document;
                    }
                    if (!this.server.isRegistered(name)) break block25;
                    MBeanInfo info = this.server.getMBeanInfo(name);
                    MBeanOperationInfo[] operations = info.getOperations();
                    match = false;
                    if (operations == null) break block26;
                    int j = 0;
                    while (j < operations.length) {
                        block28: {
                            block27: {
                                if (!operations[j].getName().equals(operationVariable)) break block27;
                                MBeanParameterInfo[] parameters = operations[j].getSignature();
                                if (parameters.length != types.size()) break block28;
                                Iterator k = types.iterator();
                                boolean signatureMatch = true;
                                int p = 0;
                                while (p < types.size()) {
                                    if (!parameters[p].getType().equals(k.next())) {
                                        signatureMatch = false;
                                        break;
                                    }
                                    ++p;
                                }
                                match = signatureMatch;
                            }
                            if (match) break;
                        }
                        ++j;
                    }
                }
                if (!match) {
                    operationElement.setAttribute("result", "error");
                    operationElement.setAttribute("errorMsg", "Operation singature has no match in the MBean");
                } else {
                    try {
                        Object[] params = values.toArray();
                        String[] signature = new String[types.size()];
                        types.toArray(signature);
                        Object returnValue = this.server.invoke(name, operationVariable, params, signature);
                        operationElement.setAttribute("result", "success");
                        if (returnValue != null) {
                            operationElement.setAttribute("returnclass", returnValue.getClass().getName());
                            operationElement.setAttribute("return", this.getResultAsString(returnValue));
                            break block24;
                        }
                        operationElement.setAttribute("returnclass", null);
                        operationElement.setAttribute("return", null);
                    }
                    catch (Exception e) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", e.getMessage());
                    }
                }
                break block24;
            }
            if (name != null) {
                operationElement.setAttribute("result", "error");
                operationElement.setAttribute("errorMsg", "MBean " + name + " not registered");
            }
        }
        return document;
    }

    private String getResultAsString(Object result) {
        if (result == null) {
            return "";
        }
        String rtrVal = null;
        if (result instanceof Object[]) {
            StringBuffer tmp = new StringBuffer();
            Object[] array = (Object[])result;
            int i = 0;
            while (i < array.length) {
                if (array[i] != null) {
                    tmp.append(array[i].toString());
                } else {
                    tmp.append("null");
                }
                if (i < array.length) {
                    tmp.append("\n");
                }
                ++i;
            }
            rtrVal = tmp.toString();
        } else if (result instanceof long[]) {
            StringBuffer tmp = new StringBuffer();
            long[] array = (long[])result;
            int i = 0;
            while (i < array.length) {
                tmp.append(array[i]);
                if (i < array.length) {
                    tmp.append("\n");
                }
                ++i;
            }
            rtrVal = tmp.toString();
        } else if (result instanceof double[]) {
            StringBuffer tmp = new StringBuffer();
            double[] array = (double[])result;
            int i = 0;
            while (i < array.length) {
                tmp.append(array[i]);
                if (i < array.length) {
                    tmp.append("\n");
                }
                ++i;
            }
            rtrVal = tmp.toString();
        } else if (result instanceof float[]) {
            StringBuffer tmp = new StringBuffer();
            float[] array = (float[])result;
            int i = 0;
            while (i < array.length) {
                tmp.append(array[i]);
                if (i < array.length) {
                    tmp.append("\n");
                }
                ++i;
            }
            rtrVal = tmp.toString();
        } else if (result instanceof short[]) {
            StringBuffer tmp = new StringBuffer();
            short[] array = (short[])result;
            int i = 0;
            while (i < array.length) {
                tmp.append(array[i]);
                if (i < array.length) {
                    tmp.append("\n");
                }
                ++i;
            }
            rtrVal = tmp.toString();
        } else if (result instanceof int[]) {
            StringBuffer tmp = new StringBuffer();
            int[] array = (int[])result;
            int i = 0;
            while (i < array.length) {
                tmp.append(array[i]);
                if (i < array.length) {
                    tmp.append("\n");
                }
                ++i;
            }
            rtrVal = tmp.toString();
        } else if (result instanceof byte[]) {
            StringBuffer tmp = new StringBuffer();
            byte[] array = (byte[])result;
            int i = 0;
            while (i < array.length) {
                tmp.append(array[i]);
                if (i < array.length) {
                    tmp.append("\n");
                }
                ++i;
            }
            rtrVal = tmp.toString();
        } else {
            rtrVal = result instanceof char[] ? new String((char[])result) : result.toString();
        }
        return rtrVal;
    }
}

