/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.util.logging;

import de.uniba.wiai.lspi.util.logging.DummyLogger;
import de.uniba.wiai.lspi.util.logging.Log4jLogger;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public abstract class Logger
implements Serializable {
    public static final String LOGGER_CLASS_NAME_PROPERTY_NAME = "de.uniba.wiai.lspi.util.logging.logger.class";
    public static final String LOGGING_OFF_PROPERTY_NAME = "de.uniba.wiai.lspi.util.logging.off";
    private static final String STANDARD_LOGGER_CLASS = Log4jLogger.class.getName();
    protected String name = "";
    private static final Map<String, Logger> loggerInstances = new HashMap<String, Logger>();

    protected Logger(String name) {
        this.name = name;
    }

    public static Logger getLogger(Class _class) {
        return Logger.getLogger(_class.getName());
    }

    public static synchronized Logger getLogger(String name) {
        Logger logger;
        String loggingOff = System.getProperty(LOGGING_OFF_PROPERTY_NAME);
        boolean logOff = false;
        if (loggingOff != null && loggingOff.equalsIgnoreCase("true")) {
            name = Logger.class.getName();
            logOff = true;
        }
        if ((logger = loggerInstances.get(name)) != null) {
            return logger;
        }
        if (!logOff) {
            String loggerClassName = System.getProperty(LOGGER_CLASS_NAME_PROPERTY_NAME);
            if (loggerClassName == null || loggerClassName.equals("")) {
                loggerClassName = STANDARD_LOGGER_CLASS;
            }
            try {
                Class<?> loggerClass = Class.forName(loggerClassName);
                Constructor<?> cons = loggerClass.getConstructor(String.class);
                logger = (Logger)cons.newInstance(name);
            }
            catch (Throwable t) {
                System.setProperty(LOGGING_OFF_PROPERTY_NAME, "true");
                logger = Logger.getLogger(name);
            }
        } else {
            logger = new DummyLogger(name);
        }
        loggerInstances.put(name, logger);
        return logger;
    }

    public abstract boolean isEnabledFor(LogLevel var1);

    public abstract void debug(Object var1);

    public abstract void debug(Object var1, Throwable var2);

    public abstract void info(Object var1);

    public abstract void info(Object var1, Throwable var2);

    public abstract void warn(Object var1);

    public abstract void warn(Object var1, Throwable var2);

    public abstract void error(Object var1);

    public abstract void error(Object var1, Throwable var2);

    public abstract void fatal(Object var1);

    public abstract void fatal(Object var1, Throwable var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

