/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.util.logging;

import de.uniba.wiai.lspi.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4jLogger
extends Logger {
    private static final long serialVersionUID = 6061557202317126907L;
    private String myFQN = this.getClass().getName();
    private transient org.apache.log4j.Logger logger = null;
    public static final String PROPERTIES_FILE_PROPERTY = "log4j.properties.file";
    private static boolean configured = false;

    public Log4jLogger(String _class) {
        super(_class);
        this.logger = org.apache.log4j.Logger.getLogger(_class);
        if (!configured) {
            Log4jLogger.configure();
        }
    }

    private static void configure() {
        if (!configured) {
            configured = true;
            boolean usefile = false;
            URL configURL = null;
            try {
                configURL = ClassLoader.getSystemClassLoader().getResource(System.getProperty(PROPERTIES_FILE_PROPERTY));
                if (configURL == null) {
                    File f = new File(System.getProperty(PROPERTIES_FILE_PROPERTY));
                    usefile = f.exists();
                    configURL = f.toURL();
                } else {
                    usefile = true;
                }
            }
            catch (Exception e) {
                usefile = false;
            }
            if (usefile) {
                System.out.println("[" + Thread.currentThread().getName() + "] " + "INFO " + Log4jLogger.class.getName() + " - Configuring log4j with '" + System.getProperty(PROPERTIES_FILE_PROPERTY) + "'.");
                try {
                    if (System.getProperty(PROPERTIES_FILE_PROPERTY).toLowerCase().endsWith(".xml")) {
                        DOMConfigurator.configure(configURL);
                    } else {
                        PropertyConfigurator.configure(configURL);
                    }
                    System.out.println("[" + Thread.currentThread().getName() + "] " + "INFO " + Log4jLogger.class.getName() + " - log4j configured with '" + System.getProperty(PROPERTIES_FILE_PROPERTY) + "'.");
                    Logger.getLogger(Logger.class).debug("Logger initialized.");
                }
                catch (Throwable t) {
                    System.out.println("[" + Thread.currentThread().getName() + "] " + "ERROR " + Log4jLogger.class.getName() + " - log4j could not be configured with '" + System.getProperty(PROPERTIES_FILE_PROPERTY) + "'.");
                }
            } else {
                System.out.println("[" + Thread.currentThread().getName() + "] " + "INFO " + Log4jLogger.class.getName() + " - Could not find log4j properties file with filename '" + System.getProperty(PROPERTIES_FILE_PROPERTY) + "'.");
                System.out.println("[" + Thread.currentThread().getName() + "] " + "INFO " + Log4jLogger.class.getName() + " - Logging is On.");
                BasicConfigurator.configure();
                Level level = Level.ALL;
                org.apache.log4j.Logger.getRootLogger().setLevel(level);
            }
        }
    }

    public void debug(Object msg) {
        this.logger.log(this.myFQN, Level.DEBUG, msg, null);
    }

    public void debug(Object msg, Throwable t) {
        this.logger.log(this.myFQN, Level.DEBUG, msg, t);
    }

    public void info(Object msg) {
        this.logger.log(this.myFQN, Level.INFO, msg, null);
    }

    public void info(Object msg, Throwable t) {
        this.logger.log(this.myFQN, Level.INFO, msg, t);
    }

    public void warn(Object msg) {
        this.logger.log(this.myFQN, Level.WARN, msg, null);
    }

    public void warn(Object msg, Throwable t) {
        this.logger.log(this.myFQN, Level.WARN, msg, t);
    }

    public void error(Object msg) {
        this.logger.log(this.myFQN, Level.ERROR, msg, null);
    }

    public void error(Object msg, Throwable t) {
        this.logger.log(this.myFQN, Level.ERROR, msg, t);
    }

    public void fatal(Object msg) {
        this.logger.log(this.myFQN, Level.FATAL, msg, null);
    }

    public void fatal(Object msg, Throwable t) {
        this.logger.log(this.myFQN, Level.FATAL, msg, t);
    }

    public boolean isEnabledFor(Logger.LogLevel l) {
        switch (l) {
            case DEBUG: {
                return this.logger.isEnabledFor(Level.DEBUG);
            }
            case INFO: {
                return this.logger.isEnabledFor(Level.INFO);
            }
            case WARN: {
                return this.logger.isEnabledFor(Level.WARN);
            }
            case ERROR: {
                return this.logger.isEnabledFor(Level.ERROR);
            }
            case FATAL: {
                return this.logger.isEnabledFor(Level.FATAL);
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        inputStream.defaultReadObject();
        this.logger = org.apache.log4j.Logger.getLogger(this.name);
        if (!configured) {
            Log4jLogger.configure();
        }
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.defaultWriteObject();
    }
}

