/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.util.console;

import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.CommandFactory;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import de.uniba.wiai.lspi.util.console.parser.CommandParser;
import de.uniba.wiai.lspi.util.console.parser.ParseException;
import de.uniba.wiai.lspi.util.console.parser.TokenMgrError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class ConsoleThread
extends Thread {
    static ConsoleThread console;
    protected String consoleName;
    protected CommandFactory factory;
    protected String welcome = "Welcome!";
    protected Command exitCommand;
    protected PrintStream out;
    protected PrintStream systemOut = null;
    protected OutputStream systemOutputStream = null;

    protected ConsoleThread(String name, CommandFactory f) {
        super("Console-" + name);
        this.consoleName = name;
        this.factory = f;
        this.out = f.getPrintStream();
    }

    protected ConsoleThread(String name, CommandFactory f, OutputStream systemOut) {
        this(name, f);
        this.systemOut = System.out;
        this.systemOutputStream = systemOut;
        System.setOut(new PrintStream(this.systemOutputStream));
    }

    public static ConsoleThread getConsole() {
        return console;
    }

    public static ConsoleThread getConsole(String name, CommandFactory factory) {
        if (console == null) {
            console = new ConsoleThread(name, factory);
        }
        return console;
    }

    public static ConsoleThread getConsole(String name, CommandFactory factory, OutputStream systemOut) {
        if (console == null) {
            console = new ConsoleThread(name, factory, systemOut);
        }
        return console;
    }

    public PrintStream getPrintStream() {
        return this.out;
    }

    public OutputStream getSystemOutputStream() {
        return this.systemOutputStream;
    }

    public CommandFactory getCommandFactory() {
        return this.factory;
    }

    public void setWelcomeText(String text) {
        this.welcome = text;
    }

    public void run() {
        this.out.println(this.welcome);
        boolean running = true;
        this.out.println("Console ready. ");
        while (running) {
            this.out.print(this.consoleName + " > ");
            try {
                Command com;
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                String command = reader.readLine();
                if (command == null) {
                    command = "";
                }
                if ((command = command.trim()).equals("")) continue;
                String c = CommandParser.parse(command);
                if (this.exitCommand != null && c.equalsIgnoreCase(this.exitCommand.getCommandName())) {
                    this.out.println("Exiting " + this.consoleName + "...");
                    com = this.factory.createCommand(command);
                    this.out.print("Do you really want to shutdown? ");
                    String answer = "";
                    while (answer == null || answer.length() == 0) {
                        try {
                            answer = reader.readLine();
                        }
                        catch (IOException e) {
                            answer = "";
                        }
                        if (answer == null || !answer.equalsIgnoreCase("Yes") && !answer.equalsIgnoreCase("Y")) continue;
                        com.execute();
                        running = false;
                    }
                    continue;
                }
                try {
                    com = this.factory.createCommand(command);
                    com.execute();
                }
                catch (ConsoleException e) {
                    this.out.println(e.getMessage());
                }
            }
            catch (TokenMgrError tme) {
                this.out.println("Could not parse command.");
                this.out.println(tme.getMessage());
            }
            catch (ParseException pe) {
                this.out.println("Could not parse command.");
                this.out.println(pe.getMessage());
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.out.println("An unexpected Exception occured. Could not execute command. Reason: ");
                this.out.println(t.getMessage());
            }
        }
        this.out.println("Shutting down.");
        System.setOut(System.out);
    }

    public void setExitCommand(String commandName) throws ConsoleException {
        this.exitCommand = this.factory.createCommand(commandName);
    }
}

