/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.util.console;

import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command {
    protected Object[] toCommand;
    protected Map<String, String> parameters;
    protected final String HELP_ARG1 = "help";
    protected final String HELP_ARG2 = "h";
    protected PrintStream out;

    public Command(Object[] toCommand, PrintStream out) {
        this.toCommand = new Object[toCommand.length];
        System.arraycopy(toCommand, 0, this.toCommand, 0, this.toCommand.length);
        this.out = out;
        this.parameters = new HashMap<String, String>();
    }

    public void setPrintStream(PrintStream out) {
        this.out = out;
    }

    public final void addParameter(String paramName, String paramValue) {
        this.parameters.put(paramName, paramValue);
    }

    public final void execute() throws ConsoleException {
        if (this.parameters.containsKey(this.HELP_ARG1) || this.parameters.containsKey(this.HELP_ARG2)) {
            this.printOutHelp();
        } else {
            this.exec();
        }
    }

    public abstract void exec() throws ConsoleException;

    public abstract void printOutHelp();

    public abstract String getCommandName();

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }
}

