/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.service.impl.Entries;
import de.uniba.wiai.lspi.chord.service.impl.References;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SuccessorList {
    private List<Node> successors = null;
    private ID localID;
    private int capacity;
    private References references;
    private Entries entries;
    private Logger logger;

    SuccessorList(ID localID, int numberOfEntries, References parent, Entries entries) {
        this.logger = Logger.getLogger(SuccessorList.class + "." + localID);
        this.logger.debug("Logger initialized.");
        if (localID == null || parent == null || entries == null) {
            NullPointerException e = new NullPointerException("Neither paremeter of this constructor may have value null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        if (numberOfEntries < 1) {
            throw new IllegalArgumentException("SuccessorList has to be at least of length 1! " + numberOfEntries + "is not a valid value!");
        }
        this.localID = localID;
        this.capacity = numberOfEntries;
        this.successors = new LinkedList<Node>();
        this.references = parent;
        this.entries = entries;
    }

    final void addSuccessor(Node nodeToAdd) {
        Node precedingNode;
        Node predecessor;
        if (nodeToAdd == null) {
            NullPointerException e = new NullPointerException("Parameter may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        boolean debug = this.logger.isEnabledFor(Logger.LogLevel.DEBUG);
        boolean info = this.logger.isEnabledFor(Logger.LogLevel.INFO);
        if (this.successors.contains(nodeToAdd)) {
            if (debug) {
                this.logger.debug("Reference to new node " + nodeToAdd.toString() + " is not added to successor list, because it is " + "already contained.");
            }
            return;
        }
        if (this.successors.size() >= this.capacity && nodeToAdd.getNodeID().isInInterval(this.successors.get(this.successors.size() - 1).getNodeID(), this.localID)) {
            if (debug) {
                this.logger.debug("Reference to new node " + nodeToAdd.toString() + " is not added to successor list, because the " + "list is already full and the new reference is " + "further away from the local node than all other " + "successors.");
            }
            return;
        }
        boolean inserted = false;
        for (int i = 0; i < this.successors.size() && !inserted; ++i) {
            if (!nodeToAdd.getNodeID().isInInterval(this.localID, this.successors.get(i).getNodeID())) continue;
            this.successors.add(i, nodeToAdd);
            if (info) {
                this.logger.info("Added new reference at position " + i);
            }
            inserted = true;
        }
        if (!inserted) {
            this.successors.add(nodeToAdd);
            if (info) {
                this.logger.info("Added new reference to end of list");
            }
            inserted = true;
        }
        ID fromID = (predecessor = this.references.getPredecessor()) != null ? predecessor.getNodeID() : ((precedingNode = this.references.getClosestPrecedingNode(this.localID)) != null ? precedingNode.getNodeID() : this.localID);
        ID toID = this.localID;
        Set<Entry> entriesToReplicate = this.entries.getEntriesInInterval(fromID, toID);
        try {
            nodeToAdd.insertReplicas(entriesToReplicate);
            this.logger.debug("Inserted replicas to new reference");
        }
        catch (CommunicationException e) {
            this.logger.warn("Entries could not be replicated to node " + nodeToAdd + "!", e);
        }
        if (this.successors.size() > this.capacity) {
            Node nodeToDelete = this.successors.get(this.successors.size() - 1);
            this.successors.remove(nodeToDelete);
            try {
                nodeToDelete.removeReplicas(this.localID, new HashSet<Entry>());
                this.logger.debug("Removed replicas from node " + nodeToDelete);
            }
            catch (CommunicationException e) {
                this.logger.warn("Replicas of entries could not be removed from node " + nodeToDelete + "!", e);
            }
            if (debug) {
                this.logger.debug("If no other reference to node " + nodeToDelete + " exists any more, it is disconnected.");
            }
            this.references.disconnectIfUnreferenced(nodeToDelete);
        }
    }

    final void removeReference(Node nodeToDelete) {
        if (nodeToDelete == null) {
            NullPointerException e = new NullPointerException("Reference to remove may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        this.successors.remove(nodeToDelete);
        List<Node> referencesOfFingerTable = this.references.getFirstFingerTableEntries(this.capacity);
        referencesOfFingerTable.remove(nodeToDelete);
        for (Node referenceToAdd : referencesOfFingerTable) {
            this.addSuccessor(referenceToAdd);
        }
    }

    final List<Node> getReferences() {
        return Collections.unmodifiableList(this.successors);
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("Successor List:\n");
        for (Node next : this.successors) {
            result.append("  " + next.getNodeID().toString() + ", " + next.getNodeURL() + "\n");
        }
        return result.toString();
    }

    final Node getClosestPrecedingNode(ID idToLookup) {
        if (idToLookup == null) {
            NullPointerException e = new NullPointerException("ID to look up may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        for (int i = this.successors.size() - 1; i >= 0; --i) {
            Node nextNode = this.successors.get(i);
            if (!nextNode.getNodeID().isInInterval(this.localID, idToLookup)) continue;
            return nextNode;
        }
        return null;
    }

    final boolean containsReference(Node nodeToLookup) {
        if (nodeToLookup == null) {
            NullPointerException e = new NullPointerException("Node to look up may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        return this.successors.contains(nodeToLookup);
    }

    final Node getDirectSuccessor() {
        if (this.successors.size() == 0) {
            return null;
        }
        return this.successors.get(0);
    }

    final int getCapacity() {
        return this.capacity;
    }

    final int getSize() {
        return this.successors.size();
    }
}

