/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.service.impl.NodeImpl;
import de.uniba.wiai.lspi.chord.service.impl.References;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.util.Random;

final class FixFingerTask
implements Runnable {
    private Random random = new Random();
    private NodeImpl parent;
    private Logger logger;
    private ID localID;
    private References references;

    FixFingerTask(NodeImpl parent, ID localID, References references) {
        if (parent == null || localID == null || references == null) {
            throw new NullPointerException("Neither parameter of constructor may be null!");
        }
        this.logger = Logger.getLogger(FixFingerTask.class.getName() + "." + localID);
        this.parent = parent;
        this.localID = localID;
        this.references = references;
    }

    public void run() {
        try {
            ID lookForID;
            Node newReference;
            int nextFingerToFix = this.random.nextInt(this.localID.getLength());
            if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
                this.logger.debug("fixFingers tries to get finger for key " + this.localID.addPowerOfTwo(nextFingerToFix).toString());
            }
            if ((newReference = this.parent.findSuccessor(lookForID = this.localID.addPowerOfTwo(nextFingerToFix))) != null && !this.references.containsReference(newReference)) {
                if (this.logger.isEnabledFor(Logger.LogLevel.INFO)) {
                    this.logger.info("Adding new reference " + newReference.getNodeID().toString());
                }
                this.references.addReference(newReference);
            }
            if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
                this.logger.debug("Invocation of fix fingers was successful");
            }
        }
        catch (Exception e) {
            this.logger.warn("Unexpected Exception caught in FixFingerTask!", e);
        }
    }
}

