/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Entries {
    private static final Logger logger = Logger.getLogger(Entries.class);
    private static final boolean debugEnabled = logger.isEnabledFor(Logger.LogLevel.DEBUG);
    private Map<ID, Set<Entry>> entries = Collections.synchronizedMap(new TreeMap());

    Entries() {
    }

    final void addAll(Set<Entry> entriesToAdd) {
        if (entriesToAdd == null) {
            NullPointerException e = new NullPointerException("Set of entries to be added to the local hash table may not be null!");
            logger.error("Null pointer", e);
            throw e;
        }
        for (Entry nextEntry : entriesToAdd) {
            this.add(nextEntry);
        }
        if (debugEnabled) {
            logger.debug("Set of entries of length " + entriesToAdd.size() + " was added.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void add(Entry entryToAdd) {
        if (entryToAdd == null) {
            NullPointerException e = new NullPointerException("Entry to add may not be null!");
            logger.error("Null pointer", e);
            throw e;
        }
        Map<ID, Set<Entry>> map = this.entries;
        synchronized (map) {
            Set<Object> values;
            if (this.entries.containsKey(entryToAdd.getId())) {
                values = this.entries.get(entryToAdd.getId());
            } else {
                values = new HashSet();
                this.entries.put(entryToAdd.getId(), values);
            }
            values.add(entryToAdd);
        }
        if (debugEnabled) {
            logger.debug("Entry was added: " + entryToAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remove(Entry entryToRemove) {
        if (entryToRemove == null) {
            NullPointerException e = new NullPointerException("Entry to remove may not be null!");
            logger.error("Null pointer", e);
            throw e;
        }
        Map<ID, Set<Entry>> map = this.entries;
        synchronized (map) {
            if (this.entries.containsKey(entryToRemove.getId())) {
                Set<Entry> values = this.entries.get(entryToRemove.getId());
                values.remove(entryToRemove);
                if (values.size() == 0) {
                    this.entries.remove(entryToRemove.getId());
                }
            }
        }
        if (debugEnabled) {
            logger.debug("Entry was removed: " + entryToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Set<Entry> getEntries(ID id) {
        if (id == null) {
            NullPointerException e = new NullPointerException("ID to find entries for may not be null!");
            logger.error("Null pointer", e);
            throw e;
        }
        Map<ID, Set<Entry>> map = this.entries;
        synchronized (map) {
            if (this.entries.containsKey(id)) {
                Set<Entry> entriesForID = this.entries.get(id);
                if (debugEnabled) {
                    logger.debug("Returning entries " + entriesForID);
                }
                return new HashSet<Entry>(entriesForID);
            }
        }
        if (debugEnabled) {
            logger.debug("No entries available for " + id + ". Returning empty set.");
        }
        return new HashSet<Entry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Set<Entry> getEntriesInInterval(ID fromID, ID toID) {
        if (fromID == null || toID == null) {
            NullPointerException e = new NullPointerException("Neither of the given IDs may have value null!");
            logger.error("Null pointer", e);
            throw e;
        }
        HashSet<Entry> result = new HashSet<Entry>();
        Map<ID, Set<Entry>> map = this.entries;
        synchronized (map) {
            for (ID nextID : this.entries.keySet()) {
                if (!nextID.isInInterval(fromID, toID)) continue;
                Set<Entry> entriesForID = this.entries.get(nextID);
                for (Entry entryToAdd : entriesForID) {
                    result.add(entryToAdd);
                }
            }
        }
        result.addAll(this.getEntries(toID));
        return result;
    }

    final void removeAll(Set<Entry> toRemove) {
        if (toRemove == null) {
            NullPointerException e = new NullPointerException("Set of entries may not have value null!");
            logger.error("Null pointer", e);
            throw e;
        }
        for (Entry nextEntry : toRemove) {
            this.remove(nextEntry);
        }
        if (debugEnabled) {
            logger.debug("Set of entries of length " + toRemove.size() + " was removed.");
        }
    }

    final Map<ID, Set<Entry>> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    final int getNumberOfStoredEntries() {
        return this.entries.size();
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("Entries:\n");
        for (Map.Entry<ID, Set<Entry>> entry : this.entries.entrySet()) {
            result.append("  key = " + entry.getKey().toString() + ", value = " + entry.getValue() + "\n");
        }
        return result.toString();
    }
}

