/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.service.Chord;
import de.uniba.wiai.lspi.chord.service.ChordRetrievalFuture;
import de.uniba.wiai.lspi.chord.service.Key;
import de.uniba.wiai.lspi.chord.service.ServiceException;
import de.uniba.wiai.lspi.chord.service.impl.ChordFutureImpl;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChordRetrievalFutureImpl
extends ChordFutureImpl
implements ChordRetrievalFuture {
    private Set<Serializable> result;
    private Chord chord = null;
    private Key key = null;

    private ChordRetrievalFutureImpl(Chord c, Key k) {
        this.chord = c;
        this.key = k;
    }

    final void setResult(Set<Serializable> r) {
        this.result = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Serializable> getResult() throws ServiceException, InterruptedException {
        ChordRetrievalFutureImpl chordRetrievalFutureImpl = this;
        synchronized (chordRetrievalFutureImpl) {
            while (!this.isDone()) {
                this.wait();
            }
        }
        Throwable t = this.getThrowable();
        if (t != null) {
            throw new ServiceException(t.getMessage(), t);
        }
        return this.result;
    }

    private Runnable getTask() {
        return new RetrievalTask(this.chord, this.key);
    }

    static final ChordRetrievalFutureImpl create(Executor exec, Chord c, Key k) {
        if (c == null) {
            throw new IllegalArgumentException("ChordRetrievalFuture: chord instance must not be null!");
        }
        if (k == null) {
            throw new IllegalArgumentException("ChordRetrievalFuture: key must not be null!");
        }
        ChordRetrievalFutureImpl future = new ChordRetrievalFutureImpl(c, k);
        exec.execute(future.getTask());
        return future;
    }

    private class RetrievalTask
    implements Runnable {
        private Chord chord = null;
        private Key key = null;

        private RetrievalTask(Chord chord, Key key) {
            this.chord = chord;
            this.key = key;
        }

        public void run() {
            try {
                ChordRetrievalFutureImpl.this.setResult(this.chord.retrieve(this.key));
            }
            catch (Throwable t) {
                ChordRetrievalFutureImpl.this.setThrowable(t);
            }
            ChordRetrievalFutureImpl.this.setIsDone();
        }
    }
}

