/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.service.impl.References;
import de.uniba.wiai.lspi.util.logging.Logger;

final class CheckPredecessorTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(CheckPredecessorTask.class);
    private References references;

    CheckPredecessorTask(References references) {
        if (references == null) {
            throw new NullPointerException("Parameter references may not be null!");
        }
        this.references = references;
    }

    public void run() {
        try {
            Node predecessor;
            boolean debug = logger.isEnabledFor(Logger.LogLevel.DEBUG);
            if (debug) {
                logger.debug("Check predecessor method has been invoked.");
            }
            if ((predecessor = this.references.getPredecessor()) == null) {
                logger.info("Nothing to check, as predecessor is null");
                return;
            }
            try {
                predecessor.ping();
                if (debug) {
                    logger.debug("Predecessor reached!");
                }
            }
            catch (CommunicationException e) {
                if (debug) {
                    logger.debug("Checking predecessor was NOT successful due to a communication failure! Removing predecessor reference.", e);
                }
                this.references.removeReference(predecessor);
                return;
            }
            logger.info("Invocation of check predecessor on node " + predecessor.getNodeID() + " was successful");
        }
        catch (Exception e) {
            logger.warn("Unexpected Exception caught in CheckpredecessorTask!", e);
        }
    }
}

