/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.data;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class URL
implements Serializable {
    private static final long serialVersionUID = 8223277048826783692L;
    private transient String urlString;
    private final String protocol;
    private final String host;
    private final int port;
    private final String path;
    public static final List<String> KNOWN_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("ocsocket", "oclocal", "ocrmi"));
    private static final int[] DEFAULT_PORTS = new int[]{4242, -1, 4242};
    public static final int SOCKET_PROTOCOL = 0;
    public static final int LOCAL_PROTOCOL = 1;
    public static final int RMI_PROTOCOL = 2;
    private static final String DCOLON = ":";
    private static final String SLASH = "/";
    private static final String DCOLON_SLASHES = "://";

    public URL(String urlString) throws MalformedURLException {
        this.urlString = urlString;
        int indexOfColonAndTwoSlashes = urlString.indexOf(DCOLON_SLASHES);
        if (indexOfColonAndTwoSlashes < 0) {
            throw new MalformedURLException("Not a valid URL");
        }
        this.protocol = urlString.substring(0, indexOfColonAndTwoSlashes);
        int endOfHost = (urlString = urlString.substring(indexOfColonAndTwoSlashes + 3)).indexOf(DCOLON);
        if (endOfHost >= 0) {
            this.host = urlString.substring(0, endOfHost);
            int endOfPort = (urlString = urlString.substring(endOfHost + 1)).indexOf(SLASH);
            if (endOfPort < 0) {
                throw new MalformedURLException("Not a valid URL!");
            }
            int tmp_port = Integer.parseInt(urlString.substring(0, endOfPort));
            if (tmp_port <= 0 || tmp_port >= 65536) {
                throw new MalformedURLException("Not a valid URL! Port must be between 0 and 65536!");
            }
            this.port = tmp_port;
            urlString = urlString.substring(endOfPort + 1);
        } else {
            endOfHost = urlString.indexOf(SLASH);
            if (endOfHost < 0) {
                throw new MalformedURLException("Not a valid URL");
            }
            this.host = urlString.substring(0, endOfHost);
            urlString = urlString.substring(endOfHost + 1);
            this.port = this.protocol.equalsIgnoreCase(KNOWN_PROTOCOLS.get(0)) ? DEFAULT_PORTS[0] : (this.protocol.equalsIgnoreCase(KNOWN_PROTOCOLS.get(2)) ? DEFAULT_PORTS[2] : DEFAULT_PORTS[1]);
        }
        this.path = urlString;
        boolean protocolIsKnown = false;
        for (int i = 0; i < KNOWN_PROTOCOLS.size() && !protocolIsKnown; ++i) {
            if (!this.protocol.equals(KNOWN_PROTOCOLS.get(i))) continue;
            protocolIsKnown = true;
        }
        if (!protocolIsKnown) {
            throw new MalformedURLException("Protocol is not known! " + this.protocol);
        }
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final String getHost() {
        return this.host;
    }

    public final String getPath() {
        return this.path;
    }

    public final int getPort() {
        return this.port;
    }

    public final int hashCode() {
        int hash = 17;
        hash += 37 * this.protocol.hashCode();
        hash += 37 * this.host.hashCode();
        hash += 37 * this.path.hashCode();
        return hash += 37 * this.port;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof URL) {
            URL url = (URL)obj;
            if (!url.getProtocol().equalsIgnoreCase(this.protocol)) {
                return false;
            }
            if (!url.getHost().equalsIgnoreCase(this.host)) {
                return false;
            }
            if (url.getPort() != this.port) {
                return false;
            }
            return url.getPath().equals(this.path);
        }
        return false;
    }

    public final String toString() {
        if (this.urlString == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.protocol);
            builder.append(DCOLON_SLASHES);
            builder.append(this.host);
            builder.append(DCOLON);
            builder.append(this.port);
            builder.append(SLASH);
            builder.append(this.path);
            this.urlString = builder.toString().toLowerCase();
        }
        return this.urlString;
    }
}

