/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.com.local.ChordImplAccess;
import de.uniba.wiai.lspi.chord.com.local.Registry;
import de.uniba.wiai.lspi.chord.com.local.ThreadEndpoint;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;
import java.net.MalformedURLException;

public class ShowSuccessorList
extends Command {
    public static final String COMMAND_NAME = "successors";
    public static final String NODE_PARAM = "node";

    public ShowSuccessorList(Object[] toCommand1, PrintStream out1) {
        super(toCommand1, out1);
    }

    public void exec() throws ConsoleException {
        String nodeName = (String)this.parameters.get(NODE_PARAM);
        if (nodeName == null || nodeName.length() == 0) {
            throw new ConsoleException("Not enough parameters. Please provide name of node with help of node parameter. ");
        }
        URL url = null;
        try {
            url = new URL(URL.KNOWN_PROTOCOLS.get(1) + "://" + nodeName + "/");
        }
        catch (MalformedURLException e1) {
            throw new ConsoleException(e1.getMessage());
        }
        Registry reg = (Registry)this.toCommand[0];
        ThreadEndpoint ep = reg.lookup(url);
        if (ep != null) {
            this.out.println(ChordImplAccess.fetchChordImplOfNode(ep.getNode()).printSuccessorList());
        } else {
            this.out.println("Could not finde node with name " + nodeName);
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("This command displays the successor list of the node with the name, that is provided with help of parameter 'node'");
    }
}

