/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.com.local.Registry;
import de.uniba.wiai.lspi.chord.com.local.ThreadEndpoint;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.console.Command;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ShowNodes
extends Command {
    public static final String COMMAND_NAME = "show";
    public static final String COUNT_PARAM = "count";

    public ShowNodes(Object[] toCommand1, PrintStream out1) {
        super(toCommand1, out1);
    }

    public void exec() {
        Registry reg = (Registry)this.toCommand[0];
        Map<URL, ThreadEndpoint> eps = reg.lookupAll();
        HashMap<Object, ThreadEndpoint> temp = new HashMap<Object, ThreadEndpoint>();
        if (this.parameters.containsKey(COUNT_PARAM)) {
            this.out.println("No. of nodes currently running " + eps.size());
            return;
        }
        if (eps.size() != 0) {
            Iterator<ThreadEndpoint> valueIterator = eps.values().iterator();
            Object[] ids = new ID[eps.size()];
            int index = 0;
            while (valueIterator.hasNext()) {
                ThreadEndpoint ep = valueIterator.next();
                ids[index] = ep.getNodeID();
                temp.put(ids[index], ep);
                ++index;
            }
            Arrays.sort(ids);
            this.out.println("Node list in the order as nodes are located on chord ring: ");
            for (int i = 0; i < ids.length; ++i) {
                ThreadEndpoint ep = (ThreadEndpoint)temp.get(ids[i]);
                this.out.println("Node " + ep.getURL().getHost() + " with id " + ids[i]);
            }
        } else {
            this.out.println("No nodes running.");
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("The show command prints out a list of all nodes currently present in this JVM.");
        this.out.println("The nodes are listed in the same order, in that they are arranged on the chord ring.");
        this.out.println("If you want to know the number of nodes currently running just provide 'count' parameter.");
    }
}

