/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.chord.service.Chord;
import de.uniba.wiai.lspi.chord.service.impl.ChordImpl;
import java.net.InetAddress;

public final class RemoteChordNetworkAccess {
    int protocolType = 0;
    private static final RemoteChordNetworkAccess uniqueInstance = new RemoteChordNetworkAccess();
    private Chord chordInstance = null;

    private RemoteChordNetworkAccess() {
    }

    public static RemoteChordNetworkAccess getUniqueInstance() {
        return uniqueInstance;
    }

    void join(URL bootstrapURL, int port) throws Exception {
        if (this.chordInstance != null) {
            throw new Exception("Already joined chord network!");
        }
        this.chordInstance = new ChordImpl();
        URL acceptIncomingConnections = null;
        try {
            String host = InetAddress.getLocalHost().getHostAddress();
            acceptIncomingConnections = port <= 0 || port >= 65536 ? new URL(URL.KNOWN_PROTOCOLS.get(this.protocolType) + "://" + host + "/") : new URL(URL.KNOWN_PROTOCOLS.get(this.protocolType) + "://" + host + ":" + port + "/");
        }
        catch (Exception e) {
            throw new Exception("Could not create url for this host!", e);
        }
        try {
            if (bootstrapURL == null) {
                this.chordInstance.create(acceptIncomingConnections);
            } else {
                this.chordInstance.join(acceptIncomingConnections, bootstrapURL);
            }
        }
        catch (Exception e) {
            this.chordInstance.leave();
            this.chordInstance = null;
            throw e;
        }
    }

    void leave() throws Exception {
        if (this.chordInstance == null) {
            return;
        }
        Chord chord = this.chordInstance;
        this.chordInstance = null;
        chord.leave();
    }

    Chord getChordInstance() {
        return this.chordInstance;
    }
}

