/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.com.local.ChordImplAccess;
import de.uniba.wiai.lspi.chord.com.local.Registry;
import de.uniba.wiai.lspi.chord.com.local.ThreadEndpoint;
import de.uniba.wiai.lspi.chord.console.command.entry.Key;
import de.uniba.wiai.lspi.chord.console.command.entry.Value;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;
import java.net.MalformedURLException;

public class Insert
extends Command {
    public static final String COMMAND_NAME = "insert";
    protected static final String NODE_PARAM = "node";
    protected static final String KEY_PARAM = "key";
    protected static final String VALUE_PARAM = "value";

    public Insert(Object[] toCommand1, PrintStream out1) {
        super(toCommand1, out1);
    }

    public void exec() throws ConsoleException {
        String node = (String)this.parameters.get(NODE_PARAM);
        String key = (String)this.parameters.get(KEY_PARAM);
        String value = (String)this.parameters.get(VALUE_PARAM);
        if (node == null || node.length() == 0) {
            throw new ConsoleException("Not enough parameters! node is missing.");
        }
        if (key == null || key.length() == 0) {
            throw new ConsoleException("Not enough parameters! key is missing.");
        }
        if (value == null || value.length() == 0) {
            throw new ConsoleException("Not enough parameters! value is missing.");
        }
        URL url = null;
        try {
            url = new URL(URL.KNOWN_PROTOCOLS.get(1) + "://" + node + "/");
        }
        catch (MalformedURLException e1) {
            throw new ConsoleException(e1.getMessage());
        }
        Key keyObject = new Key(key);
        Value valueObject = new Value(value);
        ThreadEndpoint ep = Registry.getRegistryInstance().lookup(url);
        if (ep == null) {
            this.out.println("Node '" + node + "' does not exist!");
            return;
        }
        try {
            ChordImplAccess.fetchChordImplOfNode(ep.getNode()).insert(keyObject, valueObject);
        }
        catch (Throwable t) {
            ConsoleException e = new ConsoleException("Exception during execution of command. " + t.getMessage());
            e.setStackTrace(t.getStackTrace());
            throw e;
        }
        this.out.println("Value '" + value + "' with key '" + key + "' inserted " + "successfully from node '" + node + "'.");
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("This command inserts a value with a provided key into the chord network.");
        this.out.println("The key is inserted starting from the node provided as parameter.");
        this.out.println("Required parameters: ");
        this.out.println("\tnode: The name of the node, from where the key is inserted.");
        this.out.println("\tkey: The key for the value.");
        this.out.println("\tvalue: The value to insert.");
        this.out.println();
    }
}

