/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.CommandFactory;
import de.uniba.wiai.lspi.util.console.ConsoleThread;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class Help
extends Command {
    public static final String COMMAND_NAME = "help";

    public Help(Object[] toCommand1, PrintStream out1) {
        super(toCommand1, out1);
    }

    public void exec() {
        CommandFactory factory = ConsoleThread.getConsole().getCommandFactory();
        Field[] fields = factory.getClass().getDeclaredFields();
        Field mapping = null;
        for (int i = 0; i < fields.length && mapping == null; ++i) {
            if (!fields[i].getType().equals(Map.class)) continue;
            this.out.println("For help with any command, type name of command plus '-h' or '-help'.");
            this.out.println("Parameters of commands are always passed to them in the format '-parametername parametervalue'.");
            this.out.println("Some parameters require no value, so only the parameter name has to be provided to the command.");
            this.out.println("Commands available from this console:");
            this.out.println("-----");
            mapping = fields[i];
            try {
                mapping.setAccessible(true);
                Hashtable mappingValue = (Hashtable)mapping.get(factory);
                Enumeration cmds = mappingValue.keys();
                int count = 0;
                while (cmds.hasMoreElements()) {
                    this.out.print(cmds.nextElement());
                    ++count;
                    if (cmds.hasMoreElements()) {
                        this.out.print(", ");
                    }
                    if (count % 5 != 0) continue;
                    this.out.println();
                }
            }
            catch (IllegalAccessException e) {
                this.out.println("No access to commands.");
            }
            this.out.println();
            this.out.println("-----");
            this.out.println("Note: Commands and parameters are case sensitive.");
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("Display a list of all commands available in this console.");
    }
}

