/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.com.local.Registry;
import de.uniba.wiai.lspi.chord.com.local.ThreadEndpoint;
import de.uniba.wiai.lspi.chord.console.command.ListParameter;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;

public class CrashNodes
extends Command {
    public static final String COMMAND_NAME = "crash";
    public static final String NAMES_PARAM = "names";
    public static final String ALL_PARAM = "all";

    public CrashNodes(Object[] toCommand1, PrintStream out1) {
        super(toCommand1, out1);
    }

    public void exec() throws ConsoleException {
        if (!this.parameters.containsKey(NAMES_PARAM) && !this.parameters.containsKey(ALL_PARAM)) {
            throw new ConsoleException("Not enough parameters. Provide at least one node name with help of names parameter.");
        }
        String namesString = (String)this.parameters.get(NAMES_PARAM);
        LinkedList<URL> names = new LinkedList<URL>();
        if (namesString != null) {
            ListParameter namesParam = new ListParameter(NAMES_PARAM, namesString, false);
            for (String name : namesParam.getList()) {
                try {
                    names.add(new URL(URL.KNOWN_PROTOCOLS.get(1) + "://" + name + "/"));
                }
                catch (MalformedURLException e) {
                    throw new ConsoleException(e.getMessage());
                }
            }
        } else if (this.parameters.containsKey(ALL_PARAM)) {
            Registry reg = (Registry)this.toCommand[0];
            Map<URL, ThreadEndpoint> all = reg.lookupAll();
            names.addAll(all.keySet());
        }
        if (names.size() == 1) {
            this.crashNode((URL)names.get(0));
            return;
        }
        Random r = new Random();
        Thread[] threads = new Thread[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            long s = r.nextLong() % 501L;
            if (s < 0L) {
                s *= -1L;
            }
            final long sleep = s;
            final URL name = (URL)names.get(i);
            threads[i] = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    CrashNodes.this.crashNode(name);
                }
            });
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    void crashNode(URL name) {
        Registry reg = (Registry)this.toCommand[0];
        ThreadEndpoint ep = reg.lookup(name);
        this.out.println("Crashing node " + name + ".");
        if (ep != null) {
            ep.crash();
            this.out.println("Node with name " + name + " crashed.");
        } else {
            this.out.println("Could not find node with name " + name);
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("Crashes all nodes provided by 'names' parameter.");
        this.out.println("The names of the node must be separated by '_' \n as for the create command.");
        this.out.println("In order to shutdown all nodes provide parameter 'all' with no value.");
    }
}

