/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console;

import de.uniba.wiai.lspi.chord.com.local.Registry;
import de.uniba.wiai.lspi.chord.console.command.ChangeProtocol;
import de.uniba.wiai.lspi.chord.console.command.CrashNodes;
import de.uniba.wiai.lspi.chord.console.command.CreateNodes;
import de.uniba.wiai.lspi.chord.console.command.Exit;
import de.uniba.wiai.lspi.chord.console.command.Help;
import de.uniba.wiai.lspi.chord.console.command.Insert;
import de.uniba.wiai.lspi.chord.console.command.InsertNetwork;
import de.uniba.wiai.lspi.chord.console.command.JoinNetwork;
import de.uniba.wiai.lspi.chord.console.command.LeaveNetwork;
import de.uniba.wiai.lspi.chord.console.command.RemoteChordNetworkAccess;
import de.uniba.wiai.lspi.chord.console.command.Remove;
import de.uniba.wiai.lspi.chord.console.command.RemoveNetwork;
import de.uniba.wiai.lspi.chord.console.command.Retrieve;
import de.uniba.wiai.lspi.chord.console.command.RetrieveNetwork;
import de.uniba.wiai.lspi.chord.console.command.ShowEntries;
import de.uniba.wiai.lspi.chord.console.command.ShowEntriesNetwork;
import de.uniba.wiai.lspi.chord.console.command.ShowFingerTable;
import de.uniba.wiai.lspi.chord.console.command.ShowFingerTableNetwork;
import de.uniba.wiai.lspi.chord.console.command.ShowNodes;
import de.uniba.wiai.lspi.chord.console.command.ShowSuccessorList;
import de.uniba.wiai.lspi.chord.console.command.ShutdownNodes;
import de.uniba.wiai.lspi.chord.console.command.Wait;
import de.uniba.wiai.lspi.chord.service.PropertiesLoader;
import de.uniba.wiai.lspi.util.console.CommandFactory;
import de.uniba.wiai.lspi.util.console.ConsoleThread;
import de.uniba.wiai.lspi.util.console.ExecuteMacro;
import de.uniba.wiai.lspi.util.console.MemoryOutputStream;
import de.uniba.wiai.lspi.util.console.ShowOutputCommand;
import java.util.Hashtable;

public class Main {
    private Main() {
    }

    public static void main(String[] args) throws Throwable {
        PropertiesLoader.loadPropertyFile();
        System.out.println("This program is free software; you can redistribute \nit and/or modify it under the terms of the GNU General \nPublic License as published by the Free Software \nFoundation; either version 2 of the License, or (at \nyour option) any later version.");
        System.out.println();
        System.out.println("A copy of the license can be found in the license.txt \nfile supplied with this software or at: \nhttp://www.gnu.org/copyleft/gpl.html");
        System.out.println();
        Hashtable<String, String> commandMapping = new Hashtable<String, String>();
        commandMapping.put("executeMacro", ExecuteMacro.class.getName());
        commandMapping.put("exit", Exit.class.getName());
        commandMapping.put("help", Help.class.getName());
        commandMapping.put("displaySystemOut", ShowOutputCommand.class.getName());
        commandMapping.put("wait", Wait.class.getName());
        commandMapping.put("crash", CrashNodes.class.getName());
        commandMapping.put("create", CreateNodes.class.getName());
        commandMapping.put("insert", Insert.class.getName());
        commandMapping.put("remove", Remove.class.getName());
        commandMapping.put("retrieve", Retrieve.class.getName());
        commandMapping.put("refs", ShowFingerTable.class.getName());
        commandMapping.put("show", ShowNodes.class.getName());
        commandMapping.put("successors", ShowSuccessorList.class.getName());
        commandMapping.put("shutdown", ShutdownNodes.class.getName());
        commandMapping.put("entries", ShowEntries.class.getName());
        commandMapping.put("joinN", JoinNetwork.class.getName());
        commandMapping.put("leaveN", LeaveNetwork.class.getName());
        commandMapping.put("insertN", InsertNetwork.class.getName());
        commandMapping.put("retrieveN", RetrieveNetwork.class.getName());
        commandMapping.put("removeN", RemoveNetwork.class.getName());
        commandMapping.put("entriesN", ShowEntriesNetwork.class.getName());
        commandMapping.put("refsN", ShowFingerTableNetwork.class.getName());
        commandMapping.put("cprotocol", ChangeProtocol.class.getName());
        Registry toCommand = Registry.getRegistryInstance();
        CommandFactory factory = new CommandFactory(new Object[]{toCommand, RemoteChordNetworkAccess.getUniqueInstance()}, System.out, commandMapping);
        ConsoleThread t = ConsoleThread.getConsole("oc", factory, new MemoryOutputStream());
        t.setWelcomeText("Welcome to Open Chord test environment.\n(C) 2004-2008 Distributed and Mobile Systems Group\nUniversity of Bamberg\n\nType 'help' for a list of available commands");
        t.setExitCommand("exit");
        t.start();
        for (int i = 0; i < args.length; ++i) {
            factory.createCommand(args[i]).exec();
        }
    }
}

