/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.socket;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Endpoint;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.Proxy;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.com.socket.MethodConstants;
import de.uniba.wiai.lspi.chord.com.socket.RemoteNodeInfo;
import de.uniba.wiai.lspi.chord.com.socket.RemoteRefsAndEntries;
import de.uniba.wiai.lspi.chord.com.socket.Request;
import de.uniba.wiai.lspi.chord.com.socket.Response;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SocketProxy
extends Proxy
implements Runnable {
    private static final Logger logger = Logger.getLogger(SocketProxy.class);
    private static Map<String, SocketProxy> proxies = new HashMap<String, SocketProxy>();
    private URL urlOfLocalNode = null;
    private long requestCounter = -1L;
    private transient Socket mySocket;
    private transient ObjectOutputStream out;
    private transient ObjectInputStream in;
    private transient Map<String, Response> responses;
    private transient Map<String, WaitingThread> waitingThreads;
    private volatile boolean disconnected = false;
    private String stringRepresentation = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketProxy create(URL urlOfLocalNode, URL url) throws CommunicationException {
        Map<String, SocketProxy> map = proxies;
        synchronized (map) {
            String proxyKey = SocketProxy.createProxyKey(urlOfLocalNode, url);
            logger.debug("Known proxies " + proxies.keySet());
            if (proxies.containsKey(proxyKey)) {
                logger.debug("Returning existing proxy for " + url);
                return proxies.get(proxyKey);
            }
            logger.debug("Creating new proxy for " + url);
            SocketProxy newProxy = new SocketProxy(url, urlOfLocalNode);
            proxies.put(proxyKey, newProxy);
            return newProxy;
        }
    }

    static void shutDownAll() {
        Set<String> keys = proxies.keySet();
        for (String key : keys) {
            proxies.get(key).disconnect();
        }
        proxies.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SocketProxy create(URL url, URL urlOfLocalNode, ID nodeID) {
        Map<String, SocketProxy> map = proxies;
        synchronized (map) {
            String proxyKey = SocketProxy.createProxyKey(urlOfLocalNode, url);
            logger.debug("Known proxies " + proxies.keySet());
            if (proxies.containsKey(proxyKey)) {
                logger.debug("Returning existing proxy for " + url);
                return proxies.get(proxyKey);
            }
            logger.debug("Creating new proxy for " + url);
            SocketProxy proxy = new SocketProxy(url, urlOfLocalNode, nodeID);
            proxies.put(proxyKey, proxy);
            return proxy;
        }
    }

    private static String createProxyKey(URL localURL, URL remoteURL) {
        return localURL.toString() + "->" + remoteURL.toString();
    }

    protected SocketProxy(URL url, URL urlOfLocalNode1, ID nodeID1) {
        super(url);
        if (url == null || urlOfLocalNode1 == null || nodeID1 == null) {
            throw new IllegalArgumentException("null");
        }
        this.urlOfLocalNode = urlOfLocalNode1;
        this.nodeID = nodeID1;
    }

    private SocketProxy(URL url, URL urlOfLocalNode1) throws CommunicationException {
        super(url);
        if (url == null || urlOfLocalNode1 == null) {
            throw new IllegalArgumentException("URLs must not be null!");
        }
        this.urlOfLocalNode = urlOfLocalNode1;
        this.initializeNodeID();
        logger.info("SocketProxy for " + url + " has been created.");
    }

    private synchronized void send(Request request) throws CommunicationException {
        try {
            logger.debug("Sending request " + request.getReplyWith());
            this.out.writeObject(request);
            this.out.flush();
            this.out.reset();
        }
        catch (IOException e) {
            throw new CommunicationException("Could not connect to node " + this.nodeURL, e);
        }
    }

    private synchronized String createIdentifier(int methodIdentifier) {
        StringBuilder uid = new StringBuilder();
        uid.append(System.currentTimeMillis());
        uid.append("-");
        uid.append(this.requestCounter++);
        uid.append("-");
        uid.append(methodIdentifier);
        return uid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response waitForResponse(Request request) throws CommunicationException {
        String responseIdentifier = request.getReplyWith();
        Response response = null;
        logger.debug("Trying to wait for response with identifier " + responseIdentifier + " for method " + MethodConstants.getMethodName(request.getRequestType()));
        Map<String, Response> map = this.responses;
        synchronized (map) {
            logger.debug("No of responses " + this.responses.size());
            if (this.disconnected) {
                throw new CommunicationException("Connection to remote host  is broken down. ");
            }
            response = this.responses.remove(responseIdentifier);
            if (response != null) {
                return response;
            }
            WaitingThread wt = new WaitingThread(Thread.currentThread());
            this.waitingThreads.put(responseIdentifier, wt);
            while (!wt.hasBeenWokenUp()) {
                try {
                    logger.debug("Waiting for response to arrive.");
                    this.responses.wait();
                }
                catch (InterruptedException e) {}
            }
            logger.debug("Have been woken up from waiting for response.");
            this.waitingThreads.remove(responseIdentifier);
            response = this.responses.remove(responseIdentifier);
            logger.debug("Response for request with identifier " + responseIdentifier + " for method " + MethodConstants.getMethodName(request.getRequestType()) + " received.");
            if (response == null) {
                logger.debug("No response received.");
                if (this.disconnected) {
                    logger.info("Connection to remote host lost.");
                    throw new CommunicationException("Connection to remote host  is broken down. ");
                }
                logger.error("There is no result, but we have not been disconnected. Something went seriously wrong!");
                throw new CommunicationException("Did not receive a response!");
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseReceived(Response response) {
        Map<String, Response> map = this.responses;
        synchronized (map) {
            logger.debug("No of waiting threads " + this.waitingThreads);
            WaitingThread waitingThread = this.waitingThreads.get(response.getInReplyTo());
            logger.debug("Response with id " + response.getInReplyTo() + "received.");
            this.responses.put(response.getInReplyTo(), response);
            if (waitingThread != null) {
                logger.debug("Waking up thread!");
                waitingThread.wakeUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionBrokenDown() {
        if (this.responses == null) {
            return;
        }
        Map<String, Response> map = this.responses;
        synchronized (map) {
            logger.info("Connection broken down!");
            this.disconnected = true;
            for (WaitingThread thread : this.waitingThreads.values()) {
                logger.debug("Interrupting waiting thread " + thread);
                thread.wakeUp();
            }
        }
    }

    private Request createRequest(int methodIdentifier, Serializable[] parameters) {
        if (logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
            logger.debug("Creating request for method " + MethodConstants.getMethodName(methodIdentifier) + " with parameters " + Arrays.deepToString(parameters));
        }
        String responseIdentifier = this.createIdentifier(methodIdentifier);
        Request request = new Request(methodIdentifier, responseIdentifier);
        request.setParameters(parameters);
        logger.debug("Request " + request + " created.");
        return request;
    }

    @Override
    public Node findSuccessor(ID key) throws CommunicationException {
        this.makeSocketAvailable();
        logger.debug("Trying to find successor for ID " + key);
        Request request = this.createRequest(0, new Serializable[]{key});
        try {
            logger.debug("Trying to send request " + request);
            this.send(request);
        }
        catch (CommunicationException ce) {
            logger.debug("Connection failed!");
            throw ce;
        }
        logger.debug("Waiting for response for request " + request);
        Response response = this.waitForResponse(request);
        logger.debug("Response " + response + " arrived.");
        if (response.isFailureResponse()) {
            throw new CommunicationException(response.getFailureReason());
        }
        try {
            RemoteNodeInfo nodeInfo = (RemoteNodeInfo)response.getResult();
            if (nodeInfo.getNodeURL().equals(this.urlOfLocalNode)) {
                return Endpoint.getEndpoint(this.urlOfLocalNode).getNode();
            }
            return SocketProxy.create(nodeInfo.getNodeURL(), this.urlOfLocalNode, nodeInfo.getNodeID());
        }
        catch (ClassCastException e) {
            String message = "Could not understand result! " + response.getResult();
            logger.fatal(message);
            throw new CommunicationException(message, e);
        }
    }

    private void initializeNodeID() throws CommunicationException {
        if (this.nodeID == null) {
            this.makeSocketAvailable();
            logger.debug("Trying to get node ID ");
            Request request = this.createRequest(1, new Serializable[0]);
            try {
                logger.debug("Trying to send request " + request);
                this.send(request);
            }
            catch (CommunicationException ce) {
                logger.debug("Connection failed!");
                throw ce;
            }
            logger.debug("Waiting for response for request " + request);
            Response response = this.waitForResponse(request);
            logger.debug("Response " + response + " arrived.");
            if (response.isFailureResponse()) {
                throw new CommunicationException(response.getFailureReason());
            }
            try {
                this.nodeID = (ID)response.getResult();
            }
            catch (ClassCastException e) {
                String message = "Could not understand result! " + response.getResult();
                logger.fatal(message);
                throw new CommunicationException(message);
            }
        }
    }

    @Override
    public List<Node> notify(Node potentialPredecessor) throws CommunicationException {
        this.makeSocketAvailable();
        RemoteNodeInfo nodeInfoToSend = new RemoteNodeInfo(potentialPredecessor.getNodeURL(), potentialPredecessor.getNodeID());
        Request request = this.createRequest(5, new Serializable[]{nodeInfoToSend});
        this.send(request);
        Response response = this.waitForResponse(request);
        if (response.isFailureResponse()) {
            throw new CommunicationException(response.getFailureReason());
        }
        try {
            List references = (List)((Object)response.getResult());
            LinkedList<Node> nodes = new LinkedList<Node>();
            for (RemoteNodeInfo nodeInfo : references) {
                if (nodeInfo.getNodeURL().equals(this.urlOfLocalNode)) {
                    nodes.add(Endpoint.getEndpoint(this.urlOfLocalNode).getNode());
                    continue;
                }
                nodes.add(SocketProxy.create(nodeInfo.getNodeURL(), this.urlOfLocalNode, nodeInfo.getNodeID()));
            }
            return nodes;
        }
        catch (ClassCastException cce) {
            throw new CommunicationException("Could not understand result! " + response.getResult(), cce);
        }
    }

    @Override
    public void ping() throws CommunicationException {
        this.makeSocketAvailable();
        boolean debugEnabled = logger.isEnabledFor(Logger.LogLevel.DEBUG);
        if (debugEnabled) {
            logger.debug("Trying to ping remote node " + this.nodeURL);
        }
        Request request = this.createRequest(7, new Serializable[0]);
        try {
            logger.debug("Trying to send request " + request);
            this.send(request);
        }
        catch (CommunicationException ce) {
            logger.debug("Connection failed!");
            throw ce;
        }
        if (debugEnabled) {
            logger.debug("Waiting for response for request " + request);
        }
        Response response = this.waitForResponse(request);
        if (debugEnabled) {
            logger.debug("Response " + response + " arrived.");
        }
        if (response.isFailureResponse()) {
            throw new CommunicationException(response.getFailureReason());
        }
    }

    @Override
    public void insertEntry(Entry entry) throws CommunicationException {
        this.makeSocketAvailable();
        logger.debug("Trying to insert entry " + entry + ".");
        Request request = this.createRequest(2, new Serializable[]{entry});
        try {
            logger.debug("Trying to send request " + request);
            this.send(request);
        }
        catch (CommunicationException ce) {
            logger.debug("Connection failed!");
            throw ce;
        }
        logger.debug("Waiting for response for request " + request);
        Response response = this.waitForResponse(request);
        logger.debug("Response " + response + " arrived.");
        if (response.isFailureResponse()) {
            throw new CommunicationException(response.getFailureReason());
        }
    }

    @Override
    public void insertReplicas(Set<Entry> replicas) throws CommunicationException {
        this.makeSocketAvailable();
        logger.debug("Trying to insert replicas " + replicas + ".");
        Request request = this.createRequest(3, new Serializable[]{(Serializable)((Object)replicas)});
        try {
            logger.debug("Trying to send request " + request);
            this.send(request);
        }
        catch (CommunicationException ce) {
            logger.debug("Connection failed!");
            throw ce;
        }
        logger.debug("Waiting for response for request " + request);
        Response response = this.waitForResponse(request);
        logger.debug("Response " + response + " arrived.");
        if (response.isFailureResponse()) {
            throw new CommunicationException(response.getFailureReason());
        }
    }

    @Override
    public void leavesNetwork(Node predecessor) throws CommunicationException {
        this.makeSocketAvailable();
        logger.debug("Trying to insert notify node that " + predecessor + " leaves network.");
        RemoteNodeInfo nodeInfo = new RemoteNodeInfo(predecessor.getNodeURL(), predecessor.getNodeID());
        Request request = this.createRequest(4, new Serializable[]{nodeInfo});
        try {
            logger.debug("Trying to send request " + request);
            this.send(request);
        }
        catch (CommunicationException ce) {
            logger.debug("Connection failed!");
            throw ce;
        }
        logger.debug("Waiting for response for request " + request);
        Response response = this.waitForResponse(request);
        logger.debug("Response " + response + " arrived.");
        if (response.isFailureResponse()) {
            throw new CommunicationException(response.getFailureReason());
        }
    }

    @Override
    public void removeEntry(Entry entry) throws CommunicationException {
        this.makeSocketAvailable();
        logger.debug("Trying to remove entry " + entry + ".");
        Request request = this.createRequest(8, new Serializable[]{entry});
        try {
            logger.debug("Trying to send request " + request);
            this.send(request);
        }
        catch (CommunicationException ce) {
            logger.debug("Connection failed!");
            throw ce;
        }
        logger.debug("Waiting for response for request " + request);
        Response response = this.waitForResponse(request);
        logger.debug("Response " + response + " arrived.");
        if (response.isFailureResponse()) {
            throw new CommunicationException(response.getFailureReason());
        }
    }

    @Override
    public void removeReplicas(ID sendingNodeID, Set<Entry> replicas) throws CommunicationException {
        this.makeSocketAvailable();
        logger.debug("Trying to remove replicas " + replicas + ".");
        Request request = this.createRequest(9, new Serializable[]{sendingNodeID, (Serializable)((Object)replicas)});
        try {
            logger.debug("Trying to send request " + request);
            this.send(request);
        }
        catch (CommunicationException ce) {
            logger.debug("Connection failed!");
            throw ce;
        }
        logger.debug("Waiting for response for request " + request);
        Response response = this.waitForResponse(request);
        logger.debug("Response " + response + " arrived.");
        if (response.isFailureResponse()) {
            throw new CommunicationException(response.getFailureReason());
        }
    }

    @Override
    public Set<Entry> retrieveEntries(ID id) throws CommunicationException {
        this.makeSocketAvailable();
        logger.debug("Trying to retrieve entries for ID " + id);
        Request request = this.createRequest(10, new Serializable[]{id});
        try {
            logger.debug("Trying to send request " + request);
            this.send(request);
        }
        catch (CommunicationException ce) {
            logger.debug("Connection failed!");
            throw ce;
        }
        logger.debug("Waiting for response for request " + request);
        Response response = this.waitForResponse(request);
        logger.debug("Response " + response + " arrived.");
        if (response.isFailureResponse()) {
            throw new CommunicationException(response.getFailureReason(), response.getThrowable());
        }
        try {
            Set result = (Set)((Object)response.getResult());
            return result;
        }
        catch (ClassCastException cce) {
            throw new CommunicationException("Could not understand result! " + response.getResult());
        }
    }

    private void makeSocketAvailable() throws CommunicationException {
        if (this.disconnected) {
            throw new CommunicationException("Connection from " + this.urlOfLocalNode + " to remote host " + this.nodeURL + " is broken down. ");
        }
        logger.debug("makeSocketAvailable() called. Testing for socket availability");
        if (this.responses == null) {
            this.responses = new HashMap<String, Response>();
        }
        if (this.waitingThreads == null) {
            this.waitingThreads = new HashMap<String, WaitingThread>();
        }
        if (this.mySocket == null) {
            try {
                logger.info("Opening new socket to " + this.nodeURL);
                this.mySocket = new Socket(this.nodeURL.getHost(), this.nodeURL.getPort());
                logger.debug("Socket created: " + this.mySocket);
                this.mySocket.setSoTimeout(5000);
                this.out = new ObjectOutputStream(this.mySocket.getOutputStream());
                this.in = new ObjectInputStream(this.mySocket.getInputStream());
                logger.debug("Sending connection request!");
                this.out.writeObject(new Request(-1, "Initial Connection"));
                try {
                    Response resp = null;
                    boolean timedOut = false;
                    try {
                        logger.debug("Waiting for connection response!");
                        resp = (Response)this.in.readObject();
                    }
                    catch (SocketTimeoutException e) {
                        logger.info("Connection timed out!");
                        timedOut = true;
                    }
                    this.mySocket.setSoTimeout(0);
                    if (timedOut) {
                        throw new CommunicationException("Connection to remote host timed out!");
                    }
                    if (resp == null || resp.getStatus() != 1) {
                        throw new CommunicationException("Establishing connection failed!");
                    }
                    Thread t = new Thread((Runnable)this, "SocketProxy_Thread_" + this.nodeURL);
                    t.start();
                }
                catch (ClassNotFoundException e) {
                    throw new CommunicationException("Unexpected result received! " + e.getMessage(), e);
                }
                catch (ClassCastException e) {
                    throw new CommunicationException("Unexpected result received! " + e.getMessage(), e);
                }
            }
            catch (UnknownHostException e) {
                throw new CommunicationException("Unknown host: " + this.nodeURL.getHost());
            }
            catch (IOException ioe) {
                throw new CommunicationException("Could not set up IO channel to host " + this.nodeURL.getHost(), ioe);
            }
        }
        logger.debug("makeSocketAvailable() finished. Socket " + this.mySocket);
    }

    protected void finalize() throws Throwable {
        logger.debug("Finalization running.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        block13: {
            logger.info("Destroying connection from " + this.urlOfLocalNode + " to " + this.nodeURL);
            Map<String, SocketProxy> map = proxies;
            synchronized (map) {
                String proxyKey = SocketProxy.createProxyKey(this.urlOfLocalNode, this.nodeURL);
                SocketProxy socketProxy = proxies.remove(proxyKey);
            }
            this.disconnected = true;
            try {
                if (this.out != null) {
                    try {
                        logger.debug("Sending shutdown notification to endpoint.");
                        Request request = this.createRequest(11, new Serializable[0]);
                        logger.debug("Notification send.");
                        this.out.writeObject(request);
                        this.out.close();
                        this.out = null;
                        logger.debug("OutputStream " + this.out + " closed.");
                    }
                    catch (IOException e) {
                        logger.debug(this + ": Exception during closing of output stream " + this.out, e);
                    }
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                        logger.debug("InputStream " + this.in + " closed.");
                        this.in = null;
                    }
                    catch (IOException e) {
                        logger.debug("Exception during closing of input stream" + this.in);
                    }
                }
                if (this.mySocket == null) break block13;
                try {
                    logger.info("Closing socket " + this.mySocket + ".");
                    this.mySocket.close();
                }
                catch (IOException e) {
                    logger.debug("Exception during closing of socket " + this.mySocket);
                }
                this.mySocket = null;
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception during disconnection of SocketProxy", t);
            }
        }
        this.connectionBrokenDown();
    }

    @Override
    public void run() {
        while (!this.disconnected) {
            try {
                Response response = (Response)this.in.readObject();
                logger.debug("Response " + response + "received!");
                this.responseReceived(response);
            }
            catch (ClassNotFoundException cnfe) {
                logger.fatal("ClassNotFoundException occured during deserialization of response. There is something seriously wrong  here! ", cnfe);
            }
            catch (IOException e) {
                if (!this.disconnected) {
                    logger.warn("Could not read response from stream!", e);
                } else {
                    logger.debug(this + ": Connection has been closed!");
                }
                this.connectionBrokenDown();
            }
        }
    }

    @Override
    public RefsAndEntries notifyAndCopyEntries(Node potentialPredecessor) throws CommunicationException {
        this.makeSocketAvailable();
        RemoteNodeInfo nodeInfoToSend = new RemoteNodeInfo(potentialPredecessor.getNodeURL(), potentialPredecessor.getNodeID());
        Request request = this.createRequest(6, new Serializable[]{nodeInfoToSend});
        try {
            logger.debug("Trying to send request " + request);
            this.send(request);
        }
        catch (CommunicationException ce) {
            logger.debug("Connection failed!");
            throw ce;
        }
        logger.debug("Waiting for response for request " + request);
        Response response = this.waitForResponse(request);
        logger.debug("Response " + response + " arrived.");
        if (response.isFailureResponse()) {
            throw new CommunicationException(response.getFailureReason(), response.getThrowable());
        }
        try {
            RemoteRefsAndEntries result = (RemoteRefsAndEntries)response.getResult();
            LinkedList<Node> newReferences = new LinkedList<Node>();
            List<RemoteNodeInfo> references = result.getNodeInfos();
            for (RemoteNodeInfo nodeInfo : references) {
                if (nodeInfo.getNodeURL().equals(this.urlOfLocalNode)) {
                    newReferences.add(Endpoint.getEndpoint(this.urlOfLocalNode).getNode());
                    continue;
                }
                newReferences.add(SocketProxy.create(nodeInfo.getNodeURL(), this.urlOfLocalNode, nodeInfo.getNodeID()));
            }
            return new RefsAndEntries(newReferences, result.getEntries());
        }
        catch (ClassCastException cce) {
            throw new CommunicationException("Could not understand result! " + response.getResult());
        }
    }

    @Override
    public String toString() {
        if (this.nodeID == null || this.mySocket == null) {
            return "Unconnected SocketProxy from " + this.urlOfLocalNode + " to " + this.nodeURL;
        }
        if (this.stringRepresentation == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Connection from Node[url=");
            builder.append(this.urlOfLocalNode);
            builder.append(", socket=");
            builder.append(this.mySocket);
            builder.append("] to Node[id=");
            builder.append(this.nodeID);
            builder.append(", url=");
            builder.append(this.nodeURL);
            builder.append("]");
            this.stringRepresentation = builder.toString();
        }
        return this.stringRepresentation;
    }

    private static class WaitingThread {
        private boolean hasBeenWokenUp = false;
        private Thread thread;

        private WaitingThread(Thread thread) {
            this.thread = thread;
        }

        boolean hasBeenWokenUp() {
            return this.hasBeenWokenUp;
        }

        void wakeUp() {
            this.hasBeenWokenUp = true;
            this.thread.interrupt();
        }

        public String toString() {
            return this.thread.toString() + ": Waiting? " + !this.hasBeenWokenUp();
        }
    }
}

