/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.socket;

import de.uniba.wiai.lspi.chord.com.socket.MethodConstants;
import de.uniba.wiai.lspi.chord.com.socket.Request;
import de.uniba.wiai.lspi.chord.com.socket.RequestHandler;
import de.uniba.wiai.lspi.chord.com.socket.Response;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class InvocationThread
implements Runnable {
    protected static final String CORE_POOL_SIZE_PROPERTY_NAME = InvocationThread.class.getName() + ".corepoolsize";
    protected static final String MAX_POOL_SIZE_PROPERTY_NAME = InvocationThread.class.getName() + ".maxpoolsize";
    protected static final String KEEP_ALIVE_TIME_PROPERTY_NAME = InvocationThread.class.getName() + ".keepalivetime";
    private static final int CORE_POOL_SIZE = Integer.parseInt(System.getProperty(CORE_POOL_SIZE_PROPERTY_NAME));
    private static final int MAX_POOL_SIZE = Integer.parseInt(System.getProperty(MAX_POOL_SIZE_PROPERTY_NAME));
    private static final int KEEP_ALIVE_TIME = Integer.parseInt(System.getProperty(KEEP_ALIVE_TIME_PROPERTY_NAME));
    private static final Logger logger = Logger.getLogger(InvocationThread.class);
    private static final boolean debug = logger.isEnabledFor(Logger.LogLevel.DEBUG);
    private Request request;
    private RequestHandler handler;
    private ObjectOutputStream out;

    InvocationThread(RequestHandler handler1, Request request1, ObjectOutputStream out1) {
        this.handler = handler1;
        this.request = request1;
        this.out = out1;
        this.handler.getEndpoint().scheduleInvocation(this);
        if (debug) {
            logger.debug("InvocationThread scheduled for request " + request1);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Invocation of ");
        sb.append(MethodConstants.getMethodName(this.request.getRequestType()));
        sb.append("] Request: ");
        sb.append(this.request);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (debug) {
            logger.debug(this + " started");
        }
        int requestType = this.request.getRequestType();
        String methodName = MethodConstants.getMethodName(requestType);
        if (debug) {
            logger.debug("Request received. Requested method: " + methodName);
        }
        try {
            if (debug) {
                logger.debug("Trying to invoke method " + methodName);
            }
            Serializable result = this.handler.invokeMethod(requestType, this.request.getParameters());
            Response response = new Response(1, requestType, this.request.getReplyWith());
            response.setResult(result);
            ObjectOutputStream objectOutputStream = this.out;
            synchronized (objectOutputStream) {
                this.out.writeObject(response);
                this.out.flush();
                this.out.reset();
            }
            logger.debug("Method invoked and result has been sent.");
        }
        catch (IOException e) {
            if (this.handler.connected) {
                logger.warn("Could not send response. Disconnecting!", e);
                this.handler.disconnect();
            }
        }
        catch (Exception t) {
            if (debug) {
                logger.debug("Throwable occured during execution of request " + MethodConstants.getMethodName(requestType) + "!");
            }
            this.handler.sendFailureResponse(t, "Could not execute request! Reason unknown! Maybe this helps: " + t.getMessage(), this.request);
        }
        this.handler = null;
        this.out = null;
        if (debug) {
            logger.debug(this + " finished");
        }
    }

    static ThreadPoolExecutor createInvocationThreadPool() {
        return new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, (long)KEEP_ALIVE_TIME, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private static final String name = "InvocationExecution-";

            public Thread newThread(Runnable r) {
                Thread newThread = new Thread(r);
                newThread.setName(name + newThread.getName());
                return newThread;
            }
        });
    }
}

