/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.local;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.Proxy;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.com.local.Registry;
import de.uniba.wiai.lspi.chord.com.local.ThreadEndpoint;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadProxy
extends Proxy {
    private static final Logger logger = Logger.getLogger(ThreadProxy.class.getName());
    protected Registry registry = Registry.getRegistryInstance();
    protected URL creatorURL;
    protected boolean isValid = true;
    protected boolean hasBeenUsed = false;
    private ThreadEndpoint endpoint = null;

    private ThreadProxy(URL creatorURL1, URL url, ID nodeID1) {
        super(url);
        this.nodeID = nodeID1;
        this.creatorURL = creatorURL1;
    }

    public ThreadProxy(URL creatorURL1, URL url) throws CommunicationException {
        super(url);
        this.creatorURL = creatorURL1;
        logger.debug("Trying to get id of node.");
        ThreadEndpoint endpoint_ = this.registry.lookup(this.nodeURL);
        logger.debug("Found endpoint " + endpoint_);
        if (endpoint_ == null) {
            throw new CommunicationException();
        }
        this.nodeID = endpoint_.getNodeID();
    }

    void reSetNodeID(ID id) {
        this.setNodeID(id);
    }

    private void checkValidity() throws CommunicationException {
        if (!this.isValid) {
            throw new CommunicationException("No valid connection!");
        }
        if (this.endpoint == null) {
            this.endpoint = this.registry.lookup(this.nodeURL);
            if (this.endpoint == null) {
                throw new CommunicationException();
            }
        }
        this.getNodeID();
        if (!this.hasBeenUsed) {
            this.hasBeenUsed = true;
            Registry.getRegistryInstance().addProxyUsedBy(this.creatorURL, this);
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void invalidate() {
        this.isValid = false;
        this.endpoint = null;
    }

    public ThreadEndpoint getEndpoint() throws CommunicationException {
        ThreadEndpoint ep = this.registry.lookup(this.nodeURL);
        if (ep == null) {
            throw new CommunicationException();
        }
        return ep;
    }

    @Override
    public Node findSuccessor(ID key) throws CommunicationException {
        this.checkValidity();
        Node succ = this.endpoint.findSuccessor(key);
        try {
            logger.debug("Creating clone of proxy " + succ);
            ThreadProxy temp = (ThreadProxy)succ;
            logger.debug("Clone created");
            return temp.cloneMeAt(this.creatorURL);
        }
        catch (Throwable t) {
            logger.debug("Exception during clone of proxy.", t);
            throw new CommunicationException(t);
        }
    }

    @Override
    public void insertEntry(Entry entry) throws CommunicationException {
        this.checkValidity();
        logger.debug("Trying to execute insert().");
        logger.debug("Found endpoint " + this.endpoint);
        this.endpoint.insertEntry(entry);
        logger.debug("insert() executed");
    }

    @Override
    public void removeEntry(Entry entry) throws CommunicationException {
        this.checkValidity();
        this.endpoint.removeEntry(entry);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[ThreadProxy ");
        buffer.append(this.nodeURL);
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public List<Node> notify(Node potentialPredecessor) throws CommunicationException {
        this.checkValidity();
        ThreadProxy potentialPredecessorProxy = new ThreadProxy(this.creatorURL, potentialPredecessor.getNodeURL());
        logger.debug("Trying to execute notify().");
        logger.debug("Found endpoint " + this.endpoint);
        List<Node> nodes = this.endpoint.notify(potentialPredecessorProxy);
        Node[] proxies = new Node[nodes.size()];
        try {
            int currentIndex = 0;
            for (Node o : nodes) {
                ThreadProxy current = (ThreadProxy)o;
                proxies[currentIndex++] = current.cloneMeAt(this.creatorURL);
            }
        }
        catch (Throwable t) {
            throw new CommunicationException(t);
        }
        return Arrays.asList(proxies);
    }

    @Override
    public void ping() throws CommunicationException {
        this.checkValidity();
        logger.debug("Trying to execute ping().");
        logger.debug("Found endpoint " + this.endpoint);
        this.endpoint.ping();
    }

    @Override
    public Set<Entry> retrieveEntries(ID id) throws CommunicationException {
        this.checkValidity();
        logger.debug("Trying to execute retrieve().");
        logger.debug("Found endpoint " + this.endpoint);
        return this.endpoint.retrieveEntries(id);
    }

    private ThreadProxy cloneMeAt(URL creatorUrl) {
        return new ThreadProxy(creatorUrl, this.nodeURL, this.nodeID);
    }

    @Override
    public void leavesNetwork(Node predecessor) throws CommunicationException {
        this.checkValidity();
        ThreadProxy predecessorProxy = new ThreadProxy(this.creatorURL, predecessor.getNodeURL());
        logger.debug("Trying to execute leavesNetwork(" + predecessor + ").");
        logger.debug("Found endpoint " + this.endpoint);
        this.endpoint.leavesNetwork(predecessorProxy);
    }

    @Override
    public void removeReplicas(ID sendingNodeID, Set<Entry> entriesToRemove) throws CommunicationException {
        this.checkValidity();
        logger.debug("Trying to execute removeReplicas(" + entriesToRemove + ").");
        logger.debug("Found endpoint " + this.endpoint);
        this.endpoint.removeReplicas(sendingNodeID, entriesToRemove);
    }

    @Override
    public void insertReplicas(Set<Entry> entries) throws CommunicationException {
        this.checkValidity();
        logger.debug("Trying to execute insertReplicas(" + entries + ").");
        logger.debug("Found endpoint " + this.endpoint);
        this.endpoint.insertReplicas(entries);
    }

    @Override
    public RefsAndEntries notifyAndCopyEntries(Node potentialPredecessor) throws CommunicationException {
        this.checkValidity();
        ThreadProxy potentialPredecessorProxy = new ThreadProxy(this.creatorURL, potentialPredecessor.getNodeURL());
        logger.debug("Trying to execute notifyAndCopyEntries().");
        logger.debug("Found endpoint " + this.endpoint);
        return this.endpoint.notifyAndCopyEntries(potentialPredecessorProxy);
    }

    @Override
    public void disconnect() {
    }
}

