/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.local.ThreadProxy;
import de.uniba.wiai.lspi.chord.com.rmi.RMIProxy;
import de.uniba.wiai.lspi.chord.com.socket.SocketProxy;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.logging.Logger;

public abstract class Proxy
extends Node {
    private static final Logger logger = Logger.getLogger(Proxy.class.getName());

    protected Proxy(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null!");
        }
        this.nodeURL = url;
        logger.info("Proxy with url " + url + " initialised.");
    }

    public static Node createConnection(URL sourceUrl, URL destinationUrl) throws CommunicationException {
        if (sourceUrl == null || destinationUrl == null) {
            throw new NullPointerException("URL must not be null!");
        }
        if (sourceUrl.equals(destinationUrl)) {
            logger.fatal("URLs are equal: this url= " + sourceUrl.toString() + ", the other url= " + destinationUrl.toString());
            throw new IllegalArgumentException("URLs must not be equal!");
        }
        boolean debug = logger.isEnabledFor(Logger.LogLevel.DEBUG);
        if (debug) {
            logger.debug("Trying to create Proxy for connection to " + destinationUrl);
        }
        String protocol = destinationUrl.getProtocol();
        Proxy node = null;
        if (protocol.equals(URL.KNOWN_PROTOCOLS.get(0))) {
            node = SocketProxy.create(sourceUrl, destinationUrl);
            if (debug) {
                logger.debug("SocketProxy " + node + " created.");
            }
        } else if (protocol.equals(URL.KNOWN_PROTOCOLS.get(1))) {
            node = new ThreadProxy(sourceUrl, destinationUrl);
            if (debug) {
                logger.debug("ThreadProxy " + node + " created.");
            }
        } else if (protocol.equals(URL.KNOWN_PROTOCOLS.get(2))) {
            node = RMIProxy.create(sourceUrl, destinationUrl);
            if (debug) {
                logger.debug("RMIProxy " + node + " created.");
            }
        } else {
            throw new RuntimeException("This should not happen! Unknown Protocol " + protocol);
        }
        return node;
    }
}

