/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    protected ID nodeID;
    protected URL nodeURL;

    public final boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof Node)) {
            return false;
        }
        return ((Node)arg0).nodeID.equals(this.nodeID);
    }

    public final int hashCode() {
        return this.nodeID.hashCode();
    }

    public String toString() {
        String id = null;
        if (this.nodeID != null) {
            id = this.nodeID.toString();
        }
        String url = "null";
        if (this.nodeURL != null) {
            url = this.nodeURL.toString();
        }
        return "Node[type=" + this.getClass().getSimpleName() + ", id=" + id + ", url=" + url + "]";
    }

    public final ID getNodeID() {
        return this.nodeID;
    }

    public final URL getNodeURL() {
        return this.nodeURL;
    }

    public abstract Node findSuccessor(ID var1) throws CommunicationException;

    public abstract List<Node> notify(Node var1) throws CommunicationException;

    public abstract RefsAndEntries notifyAndCopyEntries(Node var1) throws CommunicationException;

    public abstract void ping() throws CommunicationException;

    public abstract void insertEntry(Entry var1) throws CommunicationException;

    public abstract void insertReplicas(Set<Entry> var1) throws CommunicationException;

    public abstract void removeEntry(Entry var1) throws CommunicationException;

    public abstract void removeReplicas(ID var1, Set<Entry> var2) throws CommunicationException;

    public abstract Set<Entry> retrieveEntries(ID var1) throws CommunicationException;

    public abstract void leavesNetwork(Node var1) throws CommunicationException;

    public abstract void disconnect();

    protected final void setNodeID(ID nodeID) {
        this.nodeID = nodeID;
    }

    protected final void setNodeURL(URL nodeURL) {
        this.nodeURL = nodeURL;
    }
}

