/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor.impl;

import dareka.common.Logger;
import dareka.processor.HttpResponseHeader;
import dareka.processor.URLResource;
import dareka.processor.impl.NicoApiUtil;
import dareka.processor.impl.NicoIdInfoCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.Callable;

public class NicoCachingTitleRetriever
implements Callable<String> {
    private String type;
    private String id;

    public NicoCachingTitleRetriever(String type, String id) {
        this.type = type;
        this.id = id;
    }

    @Override
    public String call() throws Exception {
        Logger.debugWithThread("title retrieving start");
        String url = NicoApiUtil.getThumbURL(this.type, this.id);
        URLResource r = new URLResource(url);
        r.setFollowRedirects(true);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        r.transferTo(null, bout, null, null);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        new HttpResponseHeader(bin);
        String title = NicoApiUtil.getThumbTitle(bin);
        Logger.debugWithThread("title retrieving end (" + title + ")");
        NicoIdInfoCache.getInstance().put(this.type, this.id, title);
        return title;
    }
}

