/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor;

import dareka.common.Logger;
import dareka.processor.HttpHeader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class HttpUtil {
    private static final int BUF_SIZE = 32768;

    private HttpUtil() {
    }

    public static void sendHeader(Socket receiver, HttpHeader header) throws IOException {
        HttpUtil.sendHeader(receiver.getOutputStream(), header);
    }

    public static void sendHeader(OutputStream receiverOut, HttpHeader header) throws IOException {
        byte[] headerBytes = header.toString().getBytes("ISO-8859-1");
        receiverOut.write(headerBytes);
    }

    public static void sendBody(Socket receiver, Socket sender, long contentLength) throws IOException {
        SocketChannel senderCh = sender.getChannel();
        SocketChannel receiverCh = receiver.getChannel();
        HttpUtil.sendBodyOnChannel(receiverCh, senderCh, contentLength);
    }

    public static void sendBody(OutputStream out, InputStream in, long contentLength) throws IOException {
        HttpUtil.sendBodyOnChannel(Channels.newChannel(out), Channels.newChannel(in), contentLength);
    }

    private static void sendBodyOnChannel(WritableByteChannel receiverCh, ReadableByteChannel senderCh, long contentLength) throws IOException {
        long maxLength = contentLength == -1L ? Long.MAX_VALUE : contentLength;
        ByteBuffer bbuf = ByteBuffer.allocate(32768);
        int len = 0;
        long currentLength = 0L;
        while (currentLength < maxLength) {
            bbuf.clear();
            long remain = maxLength - currentLength;
            if (remain < (long)bbuf.limit()) {
                bbuf.limit((int)remain);
            }
            if ((len = senderCh.read(bbuf)) == -1) break;
            bbuf.flip();
            receiverCh.write(bbuf);
            currentLength += (long)len;
        }
        if (contentLength != -1L && len == -1) {
            Logger.warning("content may be imcomplete.");
        }
    }

    public static InputStream getDecodedInputStream(byte[] content, String contentEncoding) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            return new GZIPInputStream(in);
        }
        if ("deflate".equalsIgnoreCase(contentEncoding)) {
            return new InflaterInputStream(in);
        }
        if (contentEncoding != null) {
            Logger.warning("unknown Content-Encoding: " + contentEncoding);
        }
        return in;
    }
}

