/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor;

import dareka.common.HttpIOException;
import dareka.processor.HttpHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpResponseHeader
extends HttpHeader {
    private static final Pattern STATUS_LINE_PATTERN = Pattern.compile("^(HTTP/1.[01]) (\\d+)(?: (.*))?\r\n");
    private String version;
    private int statusCode;
    private String reason;

    public HttpResponseHeader(InputStream source) throws IOException {
        super(source);
        this.init();
    }

    public HttpResponseHeader(String source) throws IOException {
        super(source);
        this.init();
    }

    private void init() throws HttpIOException {
        Matcher m = STATUS_LINE_PATTERN.matcher(this.getStartLine());
        if (!m.find()) {
            throw new HttpIOException("invalid response:\r\n" + super.toString());
        }
        this.version = m.group(1);
        this.statusCode = Integer.parseInt(m.group(2));
        this.reason = m.group(3) == null ? "" : m.group(3);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.updateStartLine();
    }

    private void updateStartLine() {
        this.setStartLine(String.valueOf(this.version) + " " + this.statusCode + " " + this.reason + "\r\n");
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode, String reason) {
        this.statusCode = statusCode;
        this.reason = reason;
        this.updateStartLine();
    }

    public String getReason() {
        return this.reason;
    }
}

