/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor;

import dareka.common.HttpIOException;
import dareka.common.Logger;
import dareka.processor.HttpMessageHeaderHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpHeader {
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String HEAD = "HEAD";
    public static final String CONNECTION = "Connection";
    public static final String CONNECTION_CLOSE = "close";
    public static final String CONNECTION_KEEP_ALIVE = "keep-alive";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_ENCODING_DEFLATE = "deflate";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final Pattern MESSAGE_HEADER_PATTERN = Pattern.compile("^([^:]+):\\s*(.*)\r?\n");
    private static final Pattern MULTI_TOKEN_SPLIT = Pattern.compile("\\s*,\\s*");
    private String startLine;
    private HttpMessageHeaderHolder messageHeaders = new HttpMessageHeaderHolder();

    public HttpHeader(InputStream source) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.init(source);
    }

    public HttpHeader(String source) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.init(new ByteArrayInputStream(source.getBytes("ISO-8859-1")));
    }

    private void init(InputStream source) throws IOException, HttpIOException {
        int ch;
        StringBuilder headerString = new StringBuilder(512);
        int lineTopIndex = 0;
        while ((ch = source.read()) != -1) {
            headerString.append((char)ch);
            if (ch != 10) continue;
            if (headerString.toString().endsWith("\r\n\r\n")) break;
            String line = headerString.substring(lineTopIndex);
            if (lineTopIndex == 0) {
                if (line.equals("\r\n")) {
                    headerString.setLength(0);
                    continue;
                }
                this.startLine = line;
            } else {
                Matcher m = MESSAGE_HEADER_PATTERN.matcher(line);
                if (m.find()) {
                    this.messageHeaders.add(m.group(1), m.group(2));
                } else {
                    Logger.warning("invalid header field: " + line);
                }
            }
            lineTopIndex = headerString.length();
        }
        if (lineTopIndex == 0 || ch == -1) {
            throw new HttpIOException("premature end of header: " + headerString);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.startLine);
        result.append(this.messageHeaders.toString());
        result.append("\r\n");
        return result.toString();
    }

    public long getContentLength() {
        String value = this.getMessageHeader(CONTENT_LENGTH);
        if (value == null) {
            return -1L;
        }
        return Long.parseLong(value);
    }

    public void setContentLength(long contentLength) {
        this.messageHeaders.put(CONTENT_LENGTH, String.valueOf(contentLength));
    }

    public String getMessageHeader(String key) {
        return this.messageHeaders.get(key);
    }

    public HttpMessageHeaderHolder getMessageHeaders() {
        return this.messageHeaders;
    }

    public void setMessageHeader(String key, String value) {
        this.messageHeaders.put(key, value);
    }

    public void addMessageHeader(String key, String value) {
        this.messageHeaders.add(key, value);
    }

    public void removeMessageHeader(String key) {
        this.messageHeaders.remove(key);
    }

    protected String getStartLine() {
        return this.startLine;
    }

    protected void setStartLine(String startLine) {
        this.startLine = startLine;
    }

    public void removeHopByHopHeaders() {
        this.removeConnectionAndRelated();
        this.removeMessageHeader("Keep-Alive");
        this.removeMessageHeader("TE");
        this.removeMessageHeader("Trailer");
        this.removeMessageHeader("Transfer-Encoding");
        this.removeMessageHeader("Upgrade");
        this.removeMessageHeader("Proxy-Connection");
    }

    protected void removeConnectionAndRelated() {
        String[] tokens;
        String connection = this.getMessageHeader(CONNECTION);
        if (connection == null) {
            return;
        }
        String[] stringArray = tokens = MULTI_TOKEN_SPLIT.split(connection);
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            this.removeMessageHeader(token);
            ++n2;
        }
        this.removeMessageHeader(CONNECTION);
    }
}

