/*
 * Decompiled with CFR 0.152.
 */
package dareka.launcher.logview;

import dareka.launcher.common.IconImage;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogWindow {
    private static final int MAX_LINE = 1024;
    private static LogWindow instance = new LogWindow();
    private JFrame frame = new JFrame("NicoCache\u30ed\u30b0");
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JViewport viewpoint;
    private int lastScrollHeight = -1;
    private int lastViewHeight = -1;
    private boolean changedFlg = false;

    private LogWindow() {
        this.frame.setBounds(16, 16, 640, 480);
        this.frame.setIconImage(IconImage.getImage());
        Font font = new Font("Monospaced", 0, 16);
        this.textArea = new JTextArea();
        this.textArea.setFont(font);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem menu_copy = new JMenuItem("\u30b3\u30d4\u30fc");
        menu_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        popup.add(menu_copy);
        popup.addSeparator();
        final JCheckBoxMenuItem menu_wrap = new JCheckBoxMenuItem("\u53f3\u7aef\u3067\u6298\u308a\u8fd4\u3059");
        menu_wrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean blnState = menu_wrap.getState();
                LogWindow.this.textArea.setLineWrap(blnState);
                menu_wrap.setState(blnState);
            }
        });
        this.textArea.setLineWrap(menu_wrap.getState());
        popup.add(menu_wrap);
        popup.addSeparator();
        final JCheckBoxMenuItem menu_top = new JCheckBoxMenuItem("\u5e38\u306b\u6700\u524d\u9762\u306b\u8868\u793a");
        menu_top.setState(true);
        menu_top.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean blnState = menu_top.getState();
                LogWindow.this.frame.setAlwaysOnTop(blnState);
                menu_top.setState(blnState);
            }
        });
        this.frame.setAlwaysOnTop(menu_top.getState());
        popup.add(menu_top);
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    popup.show((Component)e.getSource(), e.getX(), e.getY());
                    return;
                }
                super.mousePressed(e);
            }
        });
        this.scrollPane = new JScrollPane(this.textArea);
        this.viewpoint = this.scrollPane.getViewport();
        this.viewpoint.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Rectangle rect = LogWindow.this.viewpoint.getViewRect();
                if (LogWindow.this.lastScrollHeight == LogWindow.this.textArea.getHeight() && LogWindow.this.lastViewHeight == rect.height && !LogWindow.this.changedFlg) {
                    return;
                }
                if (LogWindow.this.lastScrollHeight - LogWindow.this.lastViewHeight == rect.y) {
                    rect.setLocation(rect.x, LogWindow.this.textArea.getHeight() - rect.height);
                    LogWindow.this.textArea.scrollRectToVisible(rect);
                }
                LogWindow.this.lastScrollHeight = LogWindow.this.textArea.getHeight();
                LogWindow.this.lastViewHeight = rect.height;
                LogWindow.this.changedFlg = false;
            }
        });
        this.frame.add(this.scrollPane);
    }

    public static LogWindow getInstance() {
        return instance;
    }

    public void show() {
        this.frame.setVisible(true);
        this.frame.setState(0);
    }

    public synchronized void appendLog(String log) {
        this.textArea.append(log);
        if (this.textArea.getLineCount() > 1024) {
            try {
                int offset = this.textArea.getLineEndOffset(this.textArea.getLineCount() - 1024 - 1);
                this.textArea.getDocument().remove(0, offset);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.changedFlg = true;
        if (Boolean.getBoolean("dareka.debug")) {
            this.frame.setTitle("NicoCache\u30ed\u30b0 ( " + this.textArea.getLineCount() + " /" + 1024 + ")");
        }
    }

    public void close() {
        instance = null;
        this.frame.dispose();
        this.frame = null;
    }

    public Rectangle getBounds() {
        return this.frame.getBounds();
    }

    public void setBounds(Rectangle r) {
        this.frame.setBounds(r);
    }
}

