package matrix;
import java.util.*;


import io.*;


public class findCDSback { 
    disrand dis;
    MatrixLoad m; // original mutation matrix
	Jacobi jacobi;
	
	public static void main(String[] args) throws Exception{
		newMatrixLoad m0 = new newMatrixLoad();
        double kappa  = m0.kappa;
        double lambda = m0.lambda;
        
		String[] tmpdata = fileload.loadLine0(args[0]);

        // data input
		String[][] data2 = new String[0][0];
		if(tmpdata[0].charAt(0)=='>'){
			data2 = fastaFormat.translate(tmpdata);
		}else{
			data2 = blastFormat.translate(tmpdata);
		}

        //        
        double[] score = new double[1]; score[0] = 0.0; //to use call-by-pointer

        int size = data2[0].length / 2; // number of sequence pairs
        for(int i=0;i<size;i++){
	        String[][] result = new String[2][];
    	    // max CDS
        	result[1] = maxCDS( m0,data2[1][i*2],data2[1][i*2+1], score );
    	    // title
    	    result[0] = new String[2]; 
    	    double E = E(kappa,lambda,data2[1][i*2].length(), score[0] );
    	    result[0][0] = data2[0][i*2]   + " " + E; 
    	    result[0][1] = data2[0][i*2+1] + " " + E;
	      	fastaFormat.output(result);
        }
    }

    public static double E(double kappa, double lambda, int len, double score){
    	return( kappa*len*Math.exp(-score*lambda) );
    }

    public static String[] maxCDS(newMatrixLoad mat, String seq1, String seq2, double[] score){
    	int len = seq1.length()/3;
    	double[][] keisan = new double[3][len];
    	for(int n=0;n<3;n++){
			for(int i=0;i<len;i++){
    			keisan[n][i] = mat.value(seq1.substring(i*3,i*3+3),seq2.substring(i*3,i*3+3));
		//    		System.out.println(keisan[i]);
			}
    	}
        double max = -100;
        int maxX=0;
        int maxY=0;
    	for(int n=0;n<3;n++){
	    	for(int start=0;start<len-1;start++){
    	        double total = keisan[n][start];
    			for(int end=start+1;(end<len);end++){
            	    total+=keisan[n][end];
                	if(max<total){
                		max=total;
	                	maxX=start*3+n;
    	            	maxY=end*3+n;
        	        }
    			}
	    	}
    	}
    	String[] result = new String[3];
    	result[0] = seq1.substring(maxX,maxY);
    	result[1] = seq2.substring(maxX,maxY);
    	score[0] = max;
    	return result;
    }    


    public static double[][] highScores(newMatrixLoad mat, String seq1, String seq2, double[] score){
    	int size = seq1.length()/3;
    	int len = size/3;
    	double[][] keisan = new double[3][len];
    	double[][] result = new double[3][len];
    	for(int n=0;n<3;n++){
			for(int i=0;i<len;i++){
    			keisan[n][i] = mat.value(seq1.substring(i*3,i*3+3),seq2.substring(i*3,i*3+3));
		//    		System.out.println(keisan[i]);
			}
    	}
        double max = -100;
        int maxX=0;
        int maxY=0;
    	for(int n=0;n<3;n++){
    		double[][] tmp = new double[len][len];
	    	for(int start=0;start<len-1;start++){
    	        double total = keisan[n][start];
    			for(int end=start+1;(end<len);end++){
            	    total+=keisan[n][end];
            	    tmp[start][end]=total;
    			}
	    	}
	    	for(int start=0;start<len-1;start++){
    	        double total = keisan[n][start];
    			for(int end=start+1;(end<len);end++){
            	    if(result[n][end]<tmp[start][end]) result[n][end]=tmp[start][end];
    			}
	    	}
	    }
    	return result;
    }    

    public static double[][] scores(newMatrixLoad mat, String seq1, String seq2, double[] score){
    	int size = seq1.length()/3;
    	int len = size/3;
    	double[][] keisan = new double[3][len];
    	double[][] result = new double[3][len];
    	for(int n=0;n<3;n++){
			for(int i=0;i<len;i++){
    			keisan[n][i] = mat.value(seq1.substring(i*3,i*3+3),seq2.substring(i*3,i*3+3));
			}
    	}
    	return keisan;
    }    

    public static double[] window5(double[] org){
    	int len = org.length;
		double[] keisan = new double[len];
		keisan[0]=org[0];
		keisan[1]=org[0]+org[1];
    	for(int i=2;i<len-2;i++){
    		keisan[i] = org[i-2]+org[i-1]+org[i]+org[i+1]+org[i+2]; 
    	}
    	return keisan;
    }    

    public static double max50(newMatrixLoad mat, String seq1, String seq2){
    	int len = seq1.length()/3;
    	double[] keisan = new double[len];
    	for(int i=0;i<len;i++){
    		keisan[i] = mat.value(seq1.substring(i*3,i*3+3),seq2.substring(i*3,i*3+3));
//    		System.out.println(keisan[i]);
    	}
        double max = -100;
        int maxX=0;
        int maxY=0;
    	for(int start=0;start<len-1;start++){
            double total = keisan[start];
    		for(int end=start+1;(end<start+50)&&(end<len);end++){
                total+=keisan[end];
                if(max<total){
                	max=total;
                	maxX=start;
                	maxY=end;
                }
    		}
    	}
    	return max;
    }    

    public static double max(newMatrixLoad mat, String seq1, String seq2){
    	int len = seq1.length()/3;
    	double[] keisan = new double[len];
    	for(int i=0;i<len;i++){
    		keisan[i] = mat.value(seq1.substring(i*3,i*3+3),seq2.substring(i*3,i*3+3));
//    		System.out.println(keisan[i]);
    	}
        double max = -100;
        int maxX=0;
        int maxY=0;
    	for(int start=0;start<len-1;start++){
            double total = keisan[start];
    		for(int end=start+1;(end<len);end++){
                total+=keisan[end];
                if(max<total){
                	max=total;
                	maxX=start;
                	maxY=end;
                }
    		}
    	}
    	System.out.println(seq1.substring(maxX,maxY));
    	return max;
    }    

}
