package matrix;
import java.util.*;

import io.*;


public class ScoreSim { 
    disrand dis;
    MatrixLoad m; // original mutation matrix
	Jacobi jacobi;
	
	public static void main(String[] args) throws Exception{
		String[] data = fileload.loadLine0(args[0]);
		newMatrixLoad m0 = new newMatrixLoad(data);

		String[] data2 = fileload.loadLine0(args[1]);
		newMatrixLoad freq = new newMatrixLoad(data2);

        int repeat=(new Integer(args[2])).intValue();
        int len =(new Integer(args[3])).intValue();	// mesured by amino acid length (=number of codons)	
        for(int i=0;i<repeat;i++){
         	String[] DNA = simtree(freq,len);
            int keta = 3;
         	System.out.println(max50( m0,DNA[0].substring(1),DNA[1].substring(1) ) );
         	System.out.println(max50( m0,DNA[0].substring(2),DNA[1].substring(2) ) );
        }
    }

    public static String[] simtree(newMatrixLoad freq, int len){
    	int aminolen = len;
    	double[][] mat = freq.matrix;
        double[] org = new double[mat.length]; // original frequency
    	for(int i=0;i<mat.length;i++){
    		org[i] = 0.0;
    	    for(int j=0;j<mat[i].length;j++){
    	    	org[i]+=mat[i][j];
    	    }
    	}

    	StringBuffer SB1 = new StringBuffer();
    	StringBuffer SB2 = new StringBuffer();
    	for(int l=0;l<aminolen;l++){
    		int x = disrand.value(org);
    		int y = disrand.value(mat[x]);
       		SB1.append(freq.getCharAt(x));
       		SB2.append(freq.getCharAt(y));
    	}
        String[] result = new String[2];
        result[0] = SB1.toString();
        result[1] = SB2.toString();
    	return result;
    }
    
    public static double max50(newMatrixLoad mat, String seq1, String seq2){
    	int len = seq1.length()/3;
    	double[] keisan = new double[len];
    	for(int i=0;i<len;i++){
    		keisan[i] = mat.value(seq1.substring(i*3,i*3+3),seq2.substring(i*3,i*3+3));
//    		System.out.println(keisan[i]);
    	}
        double max = -100;
        int maxX=0;
        int maxY=0;
    	for(int start=0;start<len-1;start++){
            double total = keisan[start];
    		for(int end=start+1;(end<start+50)&&(end<len);end++){
                total+=keisan[end];
                if(max<total){
                	max=total;
                	maxX=start;
                	maxY=end;
                }
    		}
    	}
    	return max;
    }    
}
