package matrix;

/**
 * @author user
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */

import java.util.*;
import java.io.*;
import io.*;

public class CodonTable {
    HashMap table;

    public static void main(String[] args)
        throws
            FileNotFoundException,
            ClassNotFoundException,
            IllegalAccessException,
            InstantiationException,
            IOException
    {        //input
        String[][] data = fastaFormat.input(args[0]);
        String[][] result = new String[2][];
        result[0] = data[0];     // title
        result[1] = new String[data[1].length];
        for(int i=0;i<data[1].length;i++){
        	result[1][i] = longestORF(data[1][i]);
        }
        fastaFormat.output(result);
    }

    static String longestORF(String org){
    	String DNA = removegap(org);
    	String[] frame = new String[3];
    	CodonTable c = new CodonTable();
    	for(int i=0;i<frame.length;i++){
    		frame[i] = c.translate(i,DNA);
    	}
    	int longest = 0;
    	return frame[longest];
    }
    
    static String removegap(String org){
    	StringBuffer result = new StringBuffer();
    	for(int i=0;i<org.length();i++){
    		char c = org.charAt(i);
    		if( (c!='-')&&(c!='*') ) result.append(c);
    	}
    	return result.toString();
    }

	void set(String codon, String aminoacid){
        table.put( codon, aminoacid );
    }

    String tRNA(String triplet) { //connect x with AA 
        if( table.containsKey(triplet) ) {
            return ( (String) table.get( triplet ) );
        }
        return "X";
    }
    
    public String translate(int flame, String DNAsequence){
        // flame should be 0, 1, or 2
        StringBuffer ribosome = new StringBuffer();
  		for(int i=flame;i<DNAsequence.length()-2;i+=3){
  			ribosome.append(  tRNA( DNAsequence.substring(i,i+3) )  );
  		}
  		return ribosome.toString();
    }
    
    public CodonTable(){
        table = new HashMap();
        set("tct", "S"); //Serine
        set("tcc", "S"); //Serine
        set("tca", "S"); //Serine
        set("tcg", "S"); //Serine
        set("ttt", "F"); //Phenylalinine
        set("ttc", "F"); //Phenylalinine
        set("tta", "L"); //Letcine
        set("ttg", "L"); //Letcine
        set("tat", "Y"); //Tyrosine
        set("tac", "Y"); //Tyrosine
        set("taa", "x"); //Stop
        set("tag", "x"); //Stop
        set("tgt", "c"); //cysteine
        set("tgc", "c"); //cysteine
        set("tga", "x"); //Stop
        set("tgg", "W"); //Tryptophan
        set("ctt", "L"); //Letcine
        set("ctc", "L"); //Letcine
        set("cta", "L"); //Letcine
        set("ctg", "L"); //Letcine
        set("cct", "P"); //Proline
        set("ccc", "P"); //Proline
        set("cca", "P"); //Proline
        set("ccg", "P"); //Proline
        set("cat", "H"); //Histadine
        set("cac", "H"); //Histadine
        set("caa", "Q"); //glttamine
        set("cag", "Q"); //glttamine
        set("cgt", "R"); //arginine
        set("cgc", "R"); //arginine
        set("cga", "R"); //arginine
        set("cgg", "R"); //arginine
        set("att", "I"); //Isoletcine
        set("atc", "I"); //Isoletcine
        set("ata", "I"); //Isoletcine
        set("atg", "M"); //Methionine
        set("act", "T"); //Threonine
        set("acc", "T"); //Threonine
        set("aca", "T"); //Threonine
        set("acg", "T"); //Threonine
        set("aat", "N"); //asparagine
        set("aac", "N"); //asparagine
        set("aaa", "K"); //Lysine
        set("aag", "K"); //Lysine
        set("agt", "S"); //Serine
        set("agc", "S"); //Serine
        set("aga", "R"); //arginine
        set("agg", "R"); //arginine
        set("gtt", "V"); //Valine
        set("gtc", "V"); //Valine
        set("gta", "V"); //Valine
        set("gtg", "V"); //Valine
        set("gct", "A"); //alanine
        set("gcc", "A"); //alanine
        set("gca", "A"); //alanine
        set("gcg", "A"); //alanine
        set("gat", "D"); //aspartic acid
        set("gac", "D"); //aspartic acid
        set("gaa", "E"); //glutamic acid
        set("gag", "E"); //glutamic acid
        set("ggt", "G"); //glycine
        set("ggc", "G"); //glycine
        set("gga", "G"); //glycine
        set("ggg", "G"); //glycine
        set("TCT", "S"); //Serine
        set("TCC", "S"); //Serine
        set("TCA", "S"); //Serine
        set("TCG", "S"); //Serine
        set("TTT", "F"); //Phenylalinine
        set("TTC", "F"); //Phenylalinine
        set("TTA", "L"); //Letcine
        set("TTG", "L"); //Letcine
        set("TAT", "Y"); //Tyrosine
        set("TAC", "Y"); //Tyrosine
        set("TAA", "x"); //Stop
        set("TAG", "x"); //Stop
        set("TGT", "c"); //cysteine
        set("TGC", "c"); //cysteine
        set("TGA", "x"); //Stop
        set("TGG", "W"); //Tryptophan
        set("CTT", "L"); //Letcine
        set("CTC", "L"); //Letcine
        set("CTA", "L"); //Letcine
        set("CTG", "L"); //Letcine
        set("CCT", "P"); //Proline
        set("CCC", "P"); //Proline
        set("CCA", "P"); //Proline
        set("CCG", "P"); //Proline
        set("CAT", "H"); //Histadine
        set("CAC", "H"); //Histadine
        set("CAA", "Q"); //glttamine
        set("CAG", "Q"); //glttamine
        set("CGT", "R"); //arginine
        set("CGC", "R"); //arginine
        set("CGA", "R"); //arginine
        set("CGG", "R"); //arginine
        set("ATT", "I"); //Isoletcine
        set("ATC", "I"); //Isoletcine
        set("ATA", "I"); //Isoletcine
        set("ATG", "M"); //Methionine
        set("ACT", "T"); //Threonine
        set("ACC", "T"); //Threonine
        set("ACA", "T"); //Threonine
        set("ACG", "T"); //Threonine
        set("AAT", "N"); //asparagine
        set("AAC", "N"); //asparagine
        set("AAA", "K"); //Lysine
        set("AAG", "K"); //Lysine
        set("AGT", "S"); //Serine
        set("AGC", "S"); //Serine
        set("AGA", "R"); //arginine
        set("AGG", "R"); //arginine
        set("GTT", "V"); //Valine
        set("GTC", "V"); //Valine
        set("GTA", "V"); //Valine
        set("GTG", "V"); //Valine
        set("GCT", "A"); //alanine
        set("GCC", "A"); //alanine
        set("GCA", "A"); //alanine
        set("GCG", "A"); //alanine
        set("GAT", "D"); //aspartic acid
        set("GAC", "D"); //aspartic acid
        set("GAA", "E"); //glutamic acid
        set("GAG", "E"); //glutamic acid
        set("GGT", "G"); //glycine
        set("GGC", "G"); //glycine
        set("GGA", "G"); //glycine
        set("GGG", "G"); //glycine
   	}
	
}
