

void InitializeRegister()
{ /*CPUWX^̏*/
	A=0x01;
	F=0xB0;
	BC=0x0013;
	DE=0x00D8;
	HL=0x014D;
	SP=0xFFFE;
	PC=START_ADDRESS;
	CL=15;
    IME=0;
    HALT=0;
    STOP=0;
	irq_type=0;
	keyflag=0xFF;
	keyint=0;
    CPUIsRunning=1;
}

static inline void EndInterrupt()
{
	MEM[R_IF]&=~irq_bit[irq_type];
	irq_type=0;
}

static inline void Interrupt(u8 irq)
{
	if(IME && (MEM[R_IE]&irq_bit[irq])/* && !irq_type*/){
		irq_type=irq;
		IME=0;
		MEM[R_IF]|=irq_bit[irq];
		PUSH(bP,bC);
		PC=irq_adr[irq];
	}
}

void CGBEmuDlg::MainLoop()
{
	long clock=4194304;
	long vtime=70224;	/*4194304/70224=59.72*/
	int htime=456;		/*70224/154=456*/
	long ttime=0;
	DWORD WaitTime = timeGetTime() + 17;	 /*^C}[1000/59.73=16.74*/
	u32 tmppc;

	while(CPUIsRunning){

		if(keyint){	/*{^̒e*/
			keyint=0;
			MEM[R_P1]=(MEM[R_P1]&0x30)|(keyflag&0x0F);
			Interrupt(IRQ_KEY);
		}

		htime-=CL;

		if(htime<=0){	/*(1b59.73*144)*/
			htime=456+htime;
			DrawLine();
			MEM[R_LY]=(MEM[R_LY]>=154)?0:MEM[R_LY]+1;
			if(MEM[R_STAT]&0x08)Interrupt(IRQ_LCDC);/*Mode00*/
			if(MEM[R_LCDC]&0x80){ /* LCDғ*/
				if(MEM[R_LY]>=144){ /* A*/
					MEM[R_STAT]|=0x01;
					if(IME && MEM[R_LY]==144){ /* AJn*/
						Interrupt(IRQ_VBLANK);
						if(MEM[R_STAT]&0x10)Interrupt(IRQ_LCDC);/*Mode01*/
					}
				}else{	/* LCD*/
					MEM[R_STAT]&=~0x01;
					if(MEM[R_STAT]&0x20)Interrupt(IRQ_LCDC);/*Mode10*/
				}

				if(MEM[R_LY]==MEM[R_LYC]){
					MEM[R_STAT]|=0x04;
					if(MEM[R_STAT]&0x40)Interrupt(IRQ_LCDC);/*Mode11*/
				}else MEM[R_STAT]&=~0x04;
			}
		}

		rDIV+=CL;	/*256NbNłP*/
		if(rDIV>=0x100){
			rDIV-=0x100;
			MEM[R_DIV]++;
		}

		if(MEM[R_TAC]&0x04){  /*TIMA^C}[Jn*/
			rTAC=tac_table[(MEM[R_TAC]&0x03)];	/* ̓NbN̑I*/
			ttime+=CL;
			if(rTAC-ttime<=0){
				MEM[R_TIMA]++;
				ttime=rTAC-ttime;
				if((u8)(MEM[R_TIMA]+1)==0){
					MEM[R_TIMA]=MEM[R_TMA];
					Interrupt(IRQ_TIMER);
				}
			}
		}

		vtime-=CL;
        if(vtime<=0){	/*LCD̕`,(1b59.73)*/
			vtime=70224+vtime;
			/*t[XLbv*/
			if((WaitTime-FrameSkip)>=timeGetTime())LCDDraw();
			FrameCount++;
			if(fFps)ShowFps();
			Interrupt(IRQ_KEY);
			while(WaitTime > timeGetTime() && fVsync){Sleep(1);};	/*ҋ@*/
			WaitTime = timeGetTime() + 17;
		}

		clock-=CL;
		if(clock<=0){               /*NbÑJEg(1b1)*/
			vtime=70224+clock;		/*V,H-Blank̕␳*/
			htime=456+clock;
			clock=4194304+clock;
		}

		CL=(RMem(PC)==0xCB)?Cycles_cb[RMem(PC)]:Cycles[RMem(PC)];
		tmppc=(RMem(PC)==0xCB)?2:PC_table[RMem(PC)];
		CPU();
		PC+=tmppc;

#ifdef	_WIN32_GDI
		if(fNext){
			fNext=false;
			SuspendThread(m_pTMain->m_hThread);
			SuspendThread(m_pTGUI->m_hThread);
			m_pDasm->UpdateStack(true);
			m_pDasm->UpdateRegs();
			m_pDasm->SetDisasm();
		}
		if(fBreak){
			if(PC==BP1 || PC==BP2 || PC==BP3){
				SuspendThread(m_pTMain->m_hThread);
				SuspendThread(m_pTGUI->m_hThread);
				m_pDasm->UpdateStack(true);
				m_pDasm->UpdateRegs();
				m_pDasm->SetDisasm();
			}
		}
#endif	/*_WIN32_GDI*/

	}

}

