
u8 DAA(u8 opcd);

static u8 Cycles[256]={
	 4,12, 8, 8, 4, 4, 8, 4,20, 8, 8, 8, 4, 4, 8, 4,
	 4,12, 8, 8, 4, 4, 8, 4, 8, 8, 8, 8, 4, 4, 8, 4,
	 8,12, 8, 8, 4, 4, 8, 4, 8, 8, 8, 8, 4, 4, 8, 4,
	 8,12, 8, 8,12,12,12, 4, 8, 8, 8, 8, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 8, 8, 8, 8, 8, 8, 4, 8, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 8, 8,12,12,12,16, 8,32, 8, 8,12, 0,12,12, 8,32,
	 8, 8,12, 0,12,16, 8,32, 8, 8,12, 0,12, 0, 8,32,
	12, 8, 8, 0, 0,16, 8,32,16, 4,16, 0, 0, 0, 8,32, 
	12, 8, 8, 4, 0,16, 8,32,12, 8,16, 4, 0, 0, 8,32
};

static u8 Cycles_cb[256]={
	 2, 6, 4, 4, 2, 2, 4, 2,10, 4, 4, 4, 2, 2, 4, 2,
	 2, 6, 4, 4, 2, 2, 4, 2, 4, 4, 4, 4, 2, 2, 4, 2,
	 4, 6, 4, 4, 2, 2, 4, 2, 4, 4, 4, 4, 2, 2, 4, 2,
	 4, 6, 4, 4, 6, 6, 6, 2, 4, 4, 4, 4, 2, 2, 4, 2,
	 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2,
	 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2,
	 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2,
	 4, 4, 4, 4, 4, 4, 2, 4, 2, 2, 2, 2, 2, 2, 4, 2,
	 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2,
	 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2,
	 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2,
	 2, 2, 2, 2, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 4, 2,
	 4, 4, 6, 6, 6, 8, 4,16, 4, 4, 6, 0, 6, 6, 4,16,
	 4, 4, 6, 0, 6, 8, 4,16, 4, 4, 6, 0, 6, 0, 4,16,
	 6, 4, 4, 0, 0, 8, 4,16, 4, 2, 8, 0, 0, 0, 4,16, 
	 6, 4, 4, 2, 0, 8, 4,16, 6, 4, 8, 2, 0, 0, 4,16
};

static u8 PC_table[256]={
	1,3,1,1,1,1,2,1,3,1,1,1,1,1,2,1,
	2,3,1,1,1,1,2,1,2,1,1,1,1,1,2,1,
	2,3,1,1,1,1,2,1,2,1,1,1,1,1,2,1,
	2,3,1,1,1,1,2,1,2,1,1,1,1,1,2,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	0,1,0,0,0,1,2,1,0,0,0,0,0,0,2,1,
	0,1,0,0,0,1,2,1,0,0,0,0,0,0,2,1,
	2,1,1,0,0,1,2,1,2,0,3,0,0,0,2,1,
	2,1,1,1,0,1,2,1,1,1,3,1,0,0,2,1,
};


static void CPU(){
	u8 CB_flag=0;
	u8 opcode=OPCODE;
	u8 cbcode=DEST;
	static	u8	BIT_MASK_A[8] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
	static	u8	BIT_MASK_B[8] = {0xFE, 0xFD, 0xFB, 0xF7, 0xEF, 0xDF, 0xBF, 0x7F};

#include "cpu_cb.c"

	if(CB_flag==0)
	switch(opcode){
#define POP(h,l)	l=RMem(SP++);h=RMem(SP++)
#define PUSH(h,l)	SP--;WMem(SP,h);--SP;WMem(SP,l)

#define ADC(s)	if((u8)(A+s+FC))RF(_Z);else SF(_Z); RF(_N);\
			if(((A & 0x0F)+(s & 0x0F)+FC)>0x0F)SF(_H);else RF(_H);\
			if((A+s+FC)>0xFF)SF(_C);else RF(_C); A=A+s+FC
	case 0xCE : ADC(DEST);break;
	case 0x8E : ADC(RMem(HL));break;
	case 0x8F : ADC(A);break;
	case 0x88 : ADC(B);break;
	case 0x89 : ADC(C);break;
	case 0x8A : ADC(D);break;
	case 0x8B : ADC(E);break;
	case 0x8C : ADC(H);break;
	case 0x8D : ADC(L);break;

#define	ADD(s)	if((u8)(A+(s)))RF(_Z);else SF(_Z); RF(_N);\
			if(((A & 0x0F)+((s) & 0x0F))>0x0F)SF(_H);else RF(_H);\
			if((A+(s))>0xFF)SF(_C);else RF(_C); A=A+(s)
	case 0xC6 : ADD(DEST);break;
	case 0x86 : ADD(RMem(HL));break;
	case 0x87 : ADD(A);break;
	case 0x80 : ADD(B);break;
	case 0x81 : ADD(C);break;
	case 0x82 : ADD(D);break;
	case 0x83 : ADD(E);break;
	case 0x84 : ADD(H);break;
	case 0x85 : ADD(L);break;

#define ADDHL(s)	if((u8)(HL+s))RF(_Z);else SF(_Z); RF(_N);\
		if(((HL & 0x0FFF)+(s & 0x0FFF))>0x0FFF)SF(_H);else RF(_H);\
		if((HL+s)>0xFFFF)SF(_C);else RF(_C); HL+=s;
	case 0x09 : ADDHL(BC);break;
	case 0x19 : ADDHL(DE);break;
	case 0x29 : ADDHL(HL);break;
	case 0x39 : ADDHL(SP);break;

	case 0xE8 : RF(_Z);RF(_N);/*ADDSP*/
			if(((SP & 0x0FFF)+((s8)DEST & 0x0FFF))>0x0FFF)SF(_H);else RF(_H);\
			if((SP+(s8)DEST)>0xFFFF)SF(_C);else RF(_C);
			SP+=(s8)DEST;break;

#define AND(s)		A=(A & (s));if(A)RF(_Z);else SF(_Z); RF(_N);SF(_H);RF(_C);
	case 0xE6 : AND(DEST);break;
	case 0xA6 : AND(RMem(HL));break;
	case 0xA7 : AND(A);break;
	case 0xA0 : AND(B);break;
	case 0xA1 : AND(C);break;
	case 0xA2 : AND(D);break;
	case 0xA3 : AND(E);break;
	case 0xA4 : AND(H);break;
	case 0xA5 : AND(L);break;

#define CALL()		tmp16=SOURCE;PC+=3;PUSH(bP,bC);PC=tmp16
	case 0xCD : CALL();break;
	case 0xDC : if(FC){CALL();} else {PC+=3;CL-=3;}break;
	case 0xD4 : if(!FC){CALL();} else {PC+=3;CL-=3;}break;
	case 0xC4 : if(!FZ){CALL();} else {PC+=3;CL-=3;}break;
	case 0xCC : if(FZ){CALL();} else {PC+=3;CL-=3;}break;

	case 0x3F : RF(_N);RF(_H);if(!FC)SF(_C);else RF(_C);break;/*CCF*/

#define CP(s)	if(A==(s))SF(_Z);else RF(_Z); SF(_N);\
			if((A & 0x0F)<((s) & 0x0F))SF(_H);else RF(_H);\
			if(A<(s))SF(_C);else RF(_C);
	case 0xFE :	CP(DEST);break;
	case 0xBE :	CP(RMem(HL));break;
	case 0xBF :	CP(A);break;
	case 0xB8 :	CP(B);break;
	case 0xB9 :	CP(C);break;
	case 0xBA :	CP(D);break;
	case 0xBB :	CP(E);break;
	case 0xBC :	CP(H);break;
	case 0xBD :	CP(L);break;

	case 0x2F : SF(_N);SF(_H);A=~A;break;/*CPL*/

	case 0x27 : tmp8=A;if(DAA(A))RF(_Z);else SF(_Z); RF(_H);
				if(tmp8+A>0xFF)SF(_C);else RF(_C);break;/*DAA*/

#define DECB(d)		if((u8)(d-1))RF(_Z);else SF(_Z); SF(_N);\
		if(!(d & 0x0F))SF(_H);else RF(_H); d=(d-1)
	case 0x35 :	if((u8)(RMem(HL)-1))RF(_Z);else SF(_Z);SF(_N);
		if(!(RMem(HL) & 0x0F))SF(_H);else RF(_H);
		WMem(HL,(u8)((RMem(HL))-1));break;
	case 0x3D : DECB(A);break;
	case 0x05 : DECB(B);break;
	case 0x0D : DECB(C);break;
	case 0x15 : DECB(D);break;
	case 0x1D : DECB(E);break;
	case 0x25 : DECB(H);break;
	case 0x2D : DECB(L);break;

#define DECW(d)		d--
	case 0x0B : DECW(BC);break;
	case 0x1B : DECW(DE);break;
	case 0x2B : DECW(HL);break;
	case 0x3B : DECW(SP);break;

	case 0xF3 : IME=0;break;/*DI*/
	case 0xFB : IME=1;break;/*EI*/
	case 0x76 : HALT=1;break;/*HALT*/

#define INCB(dest)  if((u8)(dest+1))RF(_Z);else SF(_Z); RF(_N);\
		if(((dest & 0x0F)+1)>0x0F)SF(_H);else RF(_H); dest++
	case 0x34 : if((u8)(RMem(HL)+1))RF(_Z);else SF(_Z); RF(_N);
		if(((RMem(HL) & 0x0F)+1)>0x0F)SF(_H);else RF(_H);
		WMem(HL,(u8)((RMem(HL))+1));break;
	case 0x3C : INCB(A);break;
	case 0x04 : INCB(B);break;
	case 0x0C : INCB(C);break;
	case 0x14 : INCB(D);break;
	case 0x1C : INCB(E);break;
	case 0x24 : INCB(H);break;
	case 0x2C : INCB(L);break;

#define INCW(d)		d++
	case 0x03 : INCW(BC);break;
	case 0x13 : INCW(DE);break;
	case 0x23 : INCW(HL);break;
	case 0x33 : INCW(SP);break;

#define JP()		PC=SOURCE;CL++
	case 0xE9 : PC=HL;break;
	case 0xC3 : JP();break;
	case 0xDA : if(FC){JP();} else {PC+=3;} break;
	case 0xD2 : if(!FC){JP();} else {PC+=3;} break;
	case 0xC2 : if(!FZ){JP();} else {PC+=3;} break;
	case 0xCA : if(FZ){JP();} else {PC+=3;} break;

#define JR()		PC+=(s8)DEST;CL++
	case 0x18 : JR();break;
	case 0x38 : if(FC)JR();break;
	case 0x30 : if(!FC)JR();break;
	case 0x20 : if(!FZ)JR();break;
	case 0x28 : if(FZ)JR();break;

#define LD(dest,src)		dest=src
	case 0xEA : WMem(SOURCE,A);break;
	case 0x08 : WMem(SOURCE,RMem(SP));break;
	case 0xE0 :	WMem((u16)(0xFF00+DEST),A);break;
	case 0xE2 : WMem((u16)(0xFF00+C),A);break;
	case 0x02 : WMem(BC,A);break;
	case 0x12 : WMem(DE,A);break;
	case 0x36 : WMem(HL,DEST);break;
	case 0x77 : WMem(HL,A);break;
	case 0x70 : WMem(HL,B);break;
	case 0x71 : WMem(HL,C);break;
	case 0x72 : WMem(HL,D);break;
	case 0x73 : WMem(HL,E);break;
	case 0x74 : WMem(HL,H);break;
	case 0x75 : WMem(HL,L);break;
	case 0x3E : LD(A,DEST);break;
	case 0xFA : LD(A,RMem(SOURCE));break;
	case 0xF0 : LD(A,RMem((u16)(0xFF00+DEST)));break;
	case 0xF2 : LD(A,RMem((u16)(0xFF00+C)));break;
	case 0x0A : LD(A,RMem(BC));break;
	case 0x1A : LD(A,RMem(DE));break;
	case 0x7E : LD(A,RMem(HL));break;
	case 0x7F : LD(A,A);break;
	case 0x78 : LD(A,B);break;
	case 0x79 : LD(A,C);break;
	case 0x7A : LD(A,D);break;
	case 0x7B : LD(A,E);break;
	case 0x7C : LD(A,H);break;
	case 0x7D : LD(A,L);break;
	case 0x06 : LD(B,DEST);break;
	case 0x46 : LD(B,RMem(HL));break;
	case 0x47 : LD(B,A);break;
	case 0x40 : LD(B,B);break;
	case 0x41 : LD(B,C);break;
	case 0x42 : LD(B,D);break;
	case 0x43 : LD(B,E);break;
	case 0x44 : LD(B,H);break;
	case 0x45 : LD(B,L);break;
	case 0x01 : LD(BC,SOURCE);break;
	case 0x0E : LD(C,DEST);break;
	case 0x4E : LD(C,RMem(HL));break;
	case 0x4F : LD(C,A);break;
	case 0x48 : LD(C,B);break;
	case 0x49 : LD(C,C);break;
	case 0x4A : LD(C,D);break;
	case 0x4B : LD(C,E);break;
	case 0x4C : LD(C,H);break;
	case 0x4D : LD(C,L);break;
	case 0x16 : LD(D,DEST);break;
	case 0x56 : LD(D,RMem(HL));break;
	case 0x57 : LD(D,A);break;
	case 0x50 : LD(D,B);break;
	case 0x51 : LD(D,C);break;
	case 0x52 : LD(D,D);break;
	case 0x53 : LD(D,E);break;
	case 0x54 : LD(D,H);break;
	case 0x55 : LD(D,L);break;
	case 0x11 : LD(DE,SOURCE);break;
	case 0x1E : LD(E,DEST);break;
	case 0x5E : LD(E,RMem(HL));break;
	case 0x5F : LD(E,A);break;
	case 0x58 : LD(E,B);break;
	case 0x59 : LD(E,C);break;
	case 0x5A : LD(E,D);break;
	case 0x5B : LD(E,E);break;
	case 0x5C : LD(E,H);break;
	case 0x5D : LD(E,L);break;
	case 0x26 : LD(H,DEST);break;
	case 0x66 : LD(H,RMem(HL));break;
	case 0x67 : LD(H,A);break;
	case 0x60 : LD(H,B);break;
	case 0x61 : LD(H,C);break;
	case 0x62 : LD(H,D);break;
	case 0x63 : LD(H,E);break;
	case 0x64 : LD(H,H);break;
	case 0x65 : LD(H,L);break;
	case 0x21 : LD(HL,SOURCE);break;
	case 0xF8 : LD(HL,(SP+(s8)DEST));RF(_Z);RF(_N);
				if((RMem(HL) & 0x0F)<((u8)(SP+(s8)DEST) & 0x0F))SF(_H);else RF(_H);
				if((SP+(s8)DEST)>0xFFFF)SF(_C);else RF(_C);break;
	case 0x2E : LD(L,DEST);break;
	case 0x6E : LD(L,RMem(HL));break;
	case 0x6F : LD(L,A);break;
	case 0x68 : LD(L,B);break;
	case 0x69 : LD(L,C);break;
	case 0x6A : LD(L,D);break;
	case 0x6B : LD(L,E);break;
	case 0x6C : LD(L,H);break;
	case 0x6D : LD(L,L);break;
	case 0x31 : LD(SP,SOURCE);break;
	case 0xF9 : LD(SP,HL);break;

#define LDD()	HL--
	case 0x32 : WMem(HL,A);LDD();break;
	case 0x3A : A=RMem(HL);LDD();break;

#define LDI()	HL++
	case 0x22 : WMem(HL,A);LDI();break;
	case 0x2A : A=RMem(HL);LDI();break;

	case 0x00 : break;/*NOP*/

#define OR(s)		A=(A |(s));if(A)RF(_Z);else SF(_Z); RF(_N);RF(_H);RF(_C);
	case 0xF6 :	OR(DEST);break;
	case 0xB6 :	OR(RMem(HL));break;
	case 0xB7 :	OR(A);break;
	case 0xB0 :	OR(B);break;
	case 0xB1 :	OR(C);break;
	case 0xB2 :	OR(D);break;
	case 0xB3 :	OR(E);break;
	case 0xB4 :	OR(H);break;
	case 0xB5 :	OR(L);break;

	case 0xF1 : POP(A,F);break;
	case 0xC1 : POP(B,C);break;
	case 0xD1 : POP(D,E);break;
	case 0xE1 : POP(H,L);break;

	case 0xF5 : PUSH(A,F);break;
	case 0xC5 : PUSH(B,C);break;
	case 0xD5 : PUSH(D,E);break;
	case 0xE5 : PUSH(H,L);break;

#define RET()	PC=RMem(SP)+((RMem((u16)(SP+1)))<<8);SP+=2
	case 0xC9 : RET();break;
	case 0xD8 : if(FC){RET();}else {PC++;CL-=3;} break;
	case 0xD0 : if(!FC){RET();}else {PC++;CL-=3;} break;
	case 0xC0 : if(!FZ){RET();}else {PC++;CL-=3;} break;
	case 0xC8 : if(FZ){RET();}else {PC++;CL-=3;} break;

	case 0xD9 : RET();IME=1;EndInterrupt();break;/*RETI*/

	case 0x17 : if((u8)((A<<1)|FC))RF(_Z);else SF(_Z); RF(_N);RF(_H);
			if(A & 0x80)SF(_C);else RF(_C); A=((A<<1)|FC);break;/*RLA*/
	case 0x07 : if((u8)((A<<1)|(A>>7)))RF(_Z);else SF(_Z); RF(_N);RF(_H);
			if(A & 0x80)SF(_C);else RF(_C); A=((A<<1)|(A>>7));break;/*RLCA*/
	case 0x1F : if((u8)((A>>1)|(F&_C<<3)))RF(_Z); else SF(_Z); RF(_N);RF(_H);
			if(A & 0x01)SF(_C);else RF(_C); A=((A>>1)|(F&_C<<3));break;/*RRA*/
	case 0x0F : if((u8)((A>>1)|(A<<7)))RF(_Z);else SF(_Z); RF(_N);RF(_H);
			if(A & 0x01)SF(_C);else RF(_C); A=((A>>1)|(A<<7));break;/*RRCA*/

#define RST(d)		PUSH(bP,bC);PC=d
	case 0xC7 : RST(0x00);break;
	case 0xCF : RST(0x08);break;
	case 0xD7 : RST(0x10);break;
	case 0xDF : RST(0x18);break;
	case 0xE7 : RST(0x20);break;
	case 0xEF : RST(0x28);break;
	case 0xF7 : RST(0x30);break;
	case 0xFF : RST(0x38);break;

#define SBC(d,s)	if((u8)(d-s-FC))RF(_Z);else SF(_Z); SF(_N);\
		if((d & 0x0F)<((s+FC) & 0x0F))SF(_H);else RF(_H);\
		if((d-s-FC)<0)SF(_C);else RF(_C); d=d-s-FC
	case 0xDE :	SBC(A,DEST);break;
	case 0x9E :	SBC(A,RMem(HL));break;
	case 0x9F :	SBC(A,A);break;
	case 0x98 :	SBC(A,B);break;
	case 0x99 :	SBC(A,C);break;
	case 0x9A :	SBC(A,D);break;
	case 0x9B :	SBC(A,E);break;
	case 0x9C :	SBC(A,H);break;
	case 0x9D :	SBC(A,L);break;

	case 0x37 : RF(_N);RF(_H);SF(_C);break;/*SCF*/

	case 0x10 : STOP=1;break;/*STOP*/

#define SUB(s)	if((u8)(A-s))RF(_Z);else SF(_Z); SF(_N);\
			if((A & 0x0F)<(s & 0x0F))SF(_H);else RF(_H);\
			if((A-s)<0)SF(_C);else RF(_C); A=A-s
	case 0xD6 :	SUB(DEST);break;
	case 0x96 :	SUB(RMem(HL));break;
	case 0x97 :	SUB(A);break;
	case 0x90 :	SUB(B);break;
	case 0x91 :	SUB(C);break;
	case 0x92 :	SUB(D);break;
	case 0x93 :	SUB(E);break;
	case 0x94 :	SUB(H);break;
	case 0x95 :	SUB(L);break;

#define XOR(s)	A^=s;if(A)RF(_Z);else SF(_Z); RF(_N);RF(_H);RF(_C);
	case 0xEE :	XOR(DEST);break;
	case 0xAE :	XOR(RMem(HL));break;
	case 0xAF :	XOR(A);break;
	case 0xA8 :	XOR(B);break;
	case 0xA9 :	XOR(C);break;
	case 0xAA :	XOR(D);break;
	case 0xAB :	XOR(E);break;
	case 0xAC :	XOR(H);break;
	case 0xAD :	XOR(L);break;

	default	  : CPUIsRunning=0;
	}

}

u8 DAA(u8 opcd)
{
	char	str[3];
	u8		ret=0;

	_itoa(opcd, str, 16);
	if(str[1]!='\0'){
		if(0x30<=str[0]&&str[0]<=0x39)ret=(str[0]-0x30)*10;
		if(0x30<=str[1]&&str[1]<=0x39)ret+=str[1]-0x30;
	}
	else if(0x30<=str[0]&&str[0]<=0x39)ret=str[0]-0x30;

	return ret;
}

