// RegisterDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "RegisterDlg.h"
#include "../include/defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRegisterDlg _CAO

extern u32 RMem32(u32);
extern BOOL fRegisterDlg;
extern BOOL	fBreak, fNext;

void CRegisterDlg::OnOK()
{

}

void CRegisterDlg::OnCancel()
{
	OnClose();
}

CRegisterDlg::CRegisterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRegisterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRegisterDlg)
	m_fC = FALSE;
	m_fZ = FALSE;
	m_fV = FALSE;
	m_fN = FALSE;
	m_fIRQ = FALSE;
	m_fFIQ = FALSE;
	m_txtR0 = _T("");
	m_txtR1 = _T("");
	m_txtR10 = _T("");
	m_txtR11 = _T("");
	m_txtR12 = _T("");
	m_txtR13 = _T("");
	m_txtR14 = _T("");
	m_txtR15 = _T("");
	m_txtR16 = _T("");
	m_txtR2 = _T("");
	m_txtR3 = _T("");
	m_txtR4 = _T("");
	m_txtR5 = _T("");
	m_txtR6 = _T("");
	m_txtR7 = _T("");
	m_txtR8 = _T("");
	m_txtR9 = _T("");
	m_txtOpcode = _T("");
	m_txtMode = _T("");
	//}}AFX_DATA_INIT
}

void CRegisterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRegisterDlg)
	DDX_Check(pDX, IDC_FLAG_C, m_fC);
	DDX_Check(pDX, IDC_FLAG_Z, m_fZ);
	DDX_Check(pDX, IDC_FLAG_V, m_fV);
	DDX_Check(pDX, IDC_FLAG_N, m_fN);
	DDX_Check(pDX, IDC_FLAG_IRQ, m_fIRQ);
	DDX_Check(pDX, IDC_FLAG_FIQ, m_fFIQ);
	DDX_Text(pDX, IDC_EDIT_R0, m_txtR0);
	DDX_Text(pDX, IDC_EDIT_R1, m_txtR1);
	DDX_Text(pDX, IDC_EDIT_R10, m_txtR10);
	DDX_Text(pDX, IDC_EDIT_R11, m_txtR11);
	DDX_Text(pDX, IDC_EDIT_R12, m_txtR12);
	DDX_Text(pDX, IDC_EDIT_R13, m_txtR13);
	DDX_Text(pDX, IDC_EDIT_R14, m_txtR14);
	DDX_Text(pDX, IDC_EDIT_R15, m_txtR15);
	DDX_Text(pDX, IDC_EDIT_R16, m_txtR16);
	DDX_Text(pDX, IDC_EDIT_R2, m_txtR2);
	DDX_Text(pDX, IDC_EDIT_R3, m_txtR3);
	DDX_Text(pDX, IDC_EDIT_R4, m_txtR4);
	DDX_Text(pDX, IDC_EDIT_R5, m_txtR5);
	DDX_Text(pDX, IDC_EDIT_R6, m_txtR6);
	DDX_Text(pDX, IDC_EDIT_R7, m_txtR7);
	DDX_Text(pDX, IDC_EDIT_R8, m_txtR8);
	DDX_Text(pDX, IDC_EDIT_R9, m_txtR9);
	DDX_Text(pDX, IDC_EDIT_OPCODE, m_txtOpcode);
	DDX_Text(pDX, IDC_EDIT_MODE, m_txtMode);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRegisterDlg, CDialog)
	//{{AFX_MSG_MAP(CRegisterDlg)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, OnButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_NEXT, OnButtonNext)
	ON_BN_CLICKED(IDC_FLAG_C, OnFlagC)
	ON_BN_CLICKED(IDC_FLAG_N, OnFlagN)
	ON_BN_CLICKED(IDC_FLAG_V, OnFlagV)
	ON_BN_CLICKED(IDC_FLAG_Z, OnFlagZ)
	ON_BN_CLICKED(IDC_FLAG_FIQ, OnFlagFiq)
	ON_BN_CLICKED(IDC_FLAG_IRQ, OnFlagIrq)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegisterDlg bZ[W nh

BOOL CRegisterDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CRegisterDlg::ShowRegister()
{
	UpdateData(TRUE);
	m_txtR0.Format("%08X", R0);
	m_txtR1.Format("%08X", R1);
	m_txtR2.Format("%08X", R2);
	m_txtR3.Format("%08X", R3);
	m_txtR4.Format("%08X", R4);
	m_txtR5.Format("%08X", R5);
	m_txtR6.Format("%08X", R6);
	m_txtR7.Format("%08X", R7);
	m_txtR8.Format("%08X", R8);
	m_txtR9.Format("%08X", R9);
	m_txtR10.Format("%08X", R10);
	m_txtR11.Format("%08X", R11);
	m_txtR12.Format("%08X", R12);
	m_txtR13.Format("%08X", R13);
	m_txtR14.Format("%08X", R14);
	m_txtR15.Format("%08X", R15);
	m_txtR16.Format("%08X", R16);
	m_txtOpcode.Format("%08X", RMem32(PC));
	
	switch(R16&0x1F){
	case 0x10: m_txtMode="User";break;
	case 0x11: m_txtMode="FIQ";break;
	case 0x12: m_txtMode="IRQ";break;
	case 0x13: m_txtMode="Supervisor";break;
	case 0x17: m_txtMode="Abort";break;
	case 0x1B: m_txtMode="Undefined";break;
	case 0x1F: m_txtMode="System";break;
	default: m_txtMode="???";break;
	}

	m_fN = (CPSR & N_)?TRUE:FALSE;
	m_fZ = (CPSR & Z_)?TRUE:FALSE;
	m_fC = (CPSR & C_)?TRUE:FALSE;
	m_fV = (CPSR & V_)?TRUE:FALSE;
	m_fIRQ = (CPSR & I_)?TRUE:FALSE;
	m_fFIQ = (CPSR & F_)?TRUE:FALSE;

	if(CPSR&F_)CheckRadioButton(IDC_RADIO_STATE1, IDC_RADIO_STATE2, IDC_RADIO_STATE2);
	else CheckRadioButton(IDC_RADIO_STATE1, IDC_RADIO_STATE2, IDC_RADIO_STATE1);
	UpdateData(FALSE);
}

void CRegisterDlg::OnClose() 
{
	fRegisterDlg = FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

void CRegisterDlg::OnButtonClose() 
{
	OnClose();
}

void CRegisterDlg::OnButtonNext() 
{
	//AfxGetMainWnd()->SendMessage(WM_DEBUG_NEXT);
	fNext = TRUE;
	AfxGetMainWnd()->SendMessage(WM_ACTIVATE, 0, 0);
}

void CRegisterDlg::OnFlagC() 
{
	char str[16];
	CButton* pFlgChk = (CButton*)GetDlgItem(IDC_FLAG_C);

	if(pFlgChk->GetCheck()){
		CPSR |= C_;
	}else{
		CPSR &= C_;
	}

	sprintf(str, "%08X", CPSR);
	SetDlgItemText(IDC_EDIT_R16, str);
}

void CRegisterDlg::OnFlagN() 
{
	char str[16];
	CButton* pFlgChk = (CButton*)GetDlgItem(IDC_FLAG_N);

	if(pFlgChk->GetCheck()){
		CPSR |= N_;
	}else{
		CPSR &= ~N_;
	}
	
	sprintf(str, "%08X", CPSR);
	SetDlgItemText(IDC_EDIT_R16, str);
}

void CRegisterDlg::OnFlagV() 
{
	char str[16];
	CButton* pFlgChk = (CButton*)GetDlgItem(IDC_FLAG_V);

	if(pFlgChk->GetCheck()){
		CPSR |= V_;
	}else{
		CPSR &= ~V_;
	}
	
	sprintf(str, "%08X", CPSR);
	SetDlgItemText(IDC_EDIT_R16, str);
}

void CRegisterDlg::OnFlagZ() 
{
	char str[16];
	CButton* pFlgChk = (CButton*)GetDlgItem(IDC_FLAG_Z);

	if(pFlgChk->GetCheck()){
		CPSR |= Z_;
	}else{
		CPSR &= ~Z_;
	}
	
	sprintf(str, "%08X", CPSR);
	SetDlgItemText(IDC_EDIT_R16, str);
}

void CRegisterDlg::OnFlagFiq() 
{
	char str[16];
	CButton* pFlgChk = (CButton*)GetDlgItem(IDC_FLAG_FIQ);

	if(pFlgChk->GetCheck()){
		CPSR |= F_;
	}else{
		CPSR &= ~F_;
	}
	
	sprintf(str, "%08X", CPSR);
	SetDlgItemText(IDC_EDIT_R16, str);
}

void CRegisterDlg::OnFlagIrq() 
{
	char str[16];
	CButton* pFlgChk = (CButton*)GetDlgItem(IDC_FLAG_IRQ);

	if(pFlgChk->GetCheck()){
		CPSR |= I_;
	}else{
		CPSR &= ~I_;
	}
	
	sprintf(str, "%08X", CPSR);
	SetDlgItemText(IDC_EDIT_R16, str);
}
