// MainFrm.cpp : CMainFrame NX̓̒`s܂B
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "MainFrm.h"
#include <mmsystem.h>

#pragma comment(lib, "winmm")

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "win32_agb.h"


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_COMMAND(IDM_OPEN, OnOpen)
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_COMMAND(IDM_RESET, OnReset)
	ON_COMMAND(IDM_RUN, OnRun)
	ON_COMMAND(IDM_SHOW_DISASSEMBLER, OnShowDisassembler)
	ON_COMMAND(IDM_SHOW_REGISTER, OnShowRegister)
	ON_COMMAND(IDM_SHOW_MEMORY, OnShowMemory)
	ON_COMMAND(IDM_NEXT, OnNext)
	ON_COMMAND(IDM_STOP, OnStop)
	ON_WM_CLOSE()
	ON_COMMAND(IDM_AUTO_UPDATE, OnAutoUpdate)
	ON_COMMAND(IDM_ZOOM_1, OnZoom1)
	ON_COMMAND(IDM_ZOOM_2, OnZoom2)
	ON_COMMAND(IDM_ZOOM_3, OnZoom3)
	ON_COMMAND(IDM_ZOOM_4, OnZoom4)
	ON_COMMAND(IDM_ZOOM_FULLSCREEN, OnZoomFullscreen)
	ON_WM_TIMER()
	ON_COMMAND(IDM_SHOW_FPS, OnShowFps)
	ON_COMMAND(IDM_VSYNC, OnVsync)
	ON_WM_DROPFILES()
	ON_COMMAND(IDM_SHOW_OAM, OnShowOam)
	ON_WM_DESTROY()
	ON_WM_ACTIVATE()
	ON_COMMAND(ID_SHOW_DISPCNT, OnShowDispcnt)
	ON_MESSAGE(WM_DEBUG_NEXT, StepExecute)
	ON_COMMAND(IDM_INFORMATION, OnInformation)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̍\z/

CMainFrame::CMainFrame()
{
	fRegisterDlg		=	FALSE;
	fDisassemblerDlg	=	FALSE;
	fMemoryDlg			=	FALSE;
	fOamDlg				=	FALSE;
	fDispcntDlg			=	FALSE;

	fAutoUpdate			=	TRUE;
	fTMain				=	FALSE;
	fBreak				=	FALSE;
	fNext				=	FALSE;

	m_pDisassemblerDlg	=	NULL;
	m_pRegisterDlg		=	NULL;
	m_pMemoryDlg		=	NULL;
	m_pOamDlg			=	NULL;
	m_pDispcntDlg		=	NULL;

	BreakPoint1			=	0xFFFFFFFF;
	BreakPoint2			=	0xFFFFFFFF;
	BreakPoint3			=	0xFFFFFFFF;
	BreakPoint4			=	0xFFFFFFFF;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	// t[̃NCAg̈Ŝ߂r[쐬܂B
	if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}

	timeBeginPeriod(1);	// ^C}̐xŏ
	DragAcceptFiles(TRUE);

	OnAutoUpdate();
	OnZoom1();
	OnShowFps();
	OnVsync();

#ifdef _DEBUG
//	OnShowMemory();
	OnShowRegister();
	OnShowDisassembler();
#endif

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame NX̐ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame bZ[W nh
void CMainFrame::OnSetFocus(CWnd* pOldWnd)
{
	// r[ EBhEɃtH[JX^܂B
	m_wndView.SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// r[ɍŏɃR}h@^܂B
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// Ȃꍇɂ̓ftHg̏s܂B
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

int CMainFrame::AgbRomOpen(char *filename)
{
	int flag;
	
	if(CheckExtensionName(filename, "zip")){
		flag = OpenZipRomFile(filename, Rom, &filesize);
	}else{
		flag = OpenRomFile(filename, Rom, &filesize);
	}
	if(flag){
		MessageBox("file open error.", 0, MB_ICONSTOP);
	}else{
		InitializeMemory();
		InitializeRegister();
		UpdateDebugger();
	}

	return flag;
}

void CMainFrame::OnOpen() 
{
	OPENFILENAME ofn;
	char filename[512];

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));
	ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile = filename;
	ofn.lpstrFilter = "GameboyAdvance ROM Files (*.gba;*.bin;*.zip)\0*.gba;*.bin;*.zip\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle = 512;
	ofn.nMaxFile = 512;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_hWnd;

	if(GetOpenFileName(&ofn)){
		AgbRomOpen(filename);
	}
}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);

	GetClientRect(&clientSize);
}

void CMainFrame::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	
	// `pbZ[WƂ CFrameWnd::OnPaint() ĂяoĂ͂܂
}

void CMainFrame::OnReset() 
{
	CPUIsRunning = FALSE;

	InitializeMemory();
	InitializeRegister();

	m_wndView.DrawLCD();
}

void CMainFrame::OnRun() 
{
	CPUIsRunning = TRUE;
	m_pTMain = AfxBeginThread(ThreadMain, this);
}

UINT CMainFrame::ThreadMain(LPVOID pParam)
{
	((CMainFrame*)pParam)->Mainloop();
	
	return 0;
}

void CMainFrame::OnShowDisassembler() 
{
	if(!fDisassemblerDlg){
		if(m_pDisassemblerDlg==NULL){
			m_pDisassemblerDlg = new CDisassemblerDlg;
			m_pDisassemblerDlg->Create(IDD_DISASSEMBLER);
		}
		m_pDisassemblerDlg->ShowWindow(SW_SHOW);
		fDisassemblerDlg = TRUE;
	}else{
		m_pDisassemblerDlg->SetFocus();
	}

	m_pDisassemblerDlg->ShowDisassembler();
}

void CMainFrame::OnShowRegister() 
{
	if(!fRegisterDlg){
		if(m_pRegisterDlg==NULL){
			m_pRegisterDlg = new CRegisterDlg;
			m_pRegisterDlg->Create(IDD_REGISTER);
		}
		m_pRegisterDlg->ShowWindow(SW_SHOW);
		fRegisterDlg = TRUE;
	}else{
		m_pRegisterDlg->SetFocus();
	}

	m_pRegisterDlg->ShowRegister();
}

void CMainFrame::OnShowMemory() 
{
	if(!fMemoryDlg){
		if(m_pMemoryDlg==NULL){
			m_pMemoryDlg = new CMemoryDlg;
			m_pMemoryDlg->Create(IDD_MEMORY);
		}
		m_pMemoryDlg->ShowWindow(SW_SHOW);
		fMemoryDlg = TRUE;
	}else{
		m_pMemoryDlg->SetFocus();
	}

	m_pMemoryDlg->ShowMemory();
}

void CMainFrame::OnShowOam() 
{
	if(!fOamDlg){
		if(m_pOamDlg==NULL){
			m_pOamDlg = new COamDlg;
			m_pOamDlg->Create(IDD_OAM);
		}
		m_pOamDlg->ShowWindow(SW_SHOW);
		fOamDlg = TRUE;
	}else{
		m_pOamDlg->SetFocus();
	}

	m_pOamDlg->ShowOam();
}

void CMainFrame::OnShowDispcnt() 
{
	if(!fDispcntDlg){
		if(m_pDispcntDlg==NULL){
			m_pDispcntDlg = new CDispcntDlg;
			m_pDispcntDlg->Create(IDD_DISPCNT);
		}
		m_pDispcntDlg->ShowWindow(SW_SHOW);
		fDispcntDlg = TRUE;
	}else{
		m_pDispcntDlg->SetFocus();
	}

	m_pDispcntDlg->ShowDispcnt();
}

void CMainFrame::StepExecute()
{	/*Xebvs*/
	fBreak = 1;
	if(fBreak){
		fBreak = 0;
		CPUIsRunning = FALSE;
		Mainloop();
		UpdateDebugger();
	}
}

void CMainFrame::OnNext() 
{
	StepExecute();
}

void CMainFrame::OnStop() 
{
	CPUIsRunning = FALSE;
}

void CMainFrame::OnClose() 
{
	timeEndPeriod(1);
	KillTimer(1);
	WaitForTMain();

	if(m_pDisassemblerDlg){
		if(fDisassemblerDlg)m_pDisassemblerDlg->OnCancel();
		delete m_pDisassemblerDlg;
	}
	if(m_pRegisterDlg){
		if(fRegisterDlg)m_pRegisterDlg->OnCancel();
		delete m_pRegisterDlg;
	}
	if(m_pMemoryDlg){
		if(fMemoryDlg)m_pMemoryDlg->OnCancel();
		delete m_pMemoryDlg;
	}
	if(m_pOamDlg){
		if(fOamDlg)m_pOamDlg->OnCancel();
		delete m_pOamDlg;
	}
	if(m_pDispcntDlg){
		if(fDispcntDlg)m_pDispcntDlg->OnCancel();
		delete m_pDispcntDlg;
	}

	CFrameWnd::OnClose();
}

void CMainFrame::WaitForTMain()
{	/*MainloopXbh̏I҂*/
	int i;
	
	CPUIsRunning = FALSE;
	for(i=0; i<10 && fTMain; i++){
		Sleep(100);
	}
}

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg) 
{
	if(WM_KEYDOWN==pMsg->message){
		switch(pMsg->wParam){
		case 'Z':
			keyflag &= ~0x0001;
			break;
		case 'X':
			keyflag &= ~0x0002;
			break;
		case ' ':
			keyflag &= ~0x0004;
			break;
		case VK_RETURN:
			keyflag &= ~0x0008;
			break;
		case VK_RIGHT:
			keyflag &= ~0x0010;
			break;
		case VK_LEFT:
			keyflag &= ~0x0020;
			break;
		case VK_UP:
			keyflag &= ~0x0040;
			break;
		case VK_DOWN:
			keyflag &= ~0x0080;
			break;
		case 'S':
			keyflag &= ~0x0100;
			break;
		case 'A':
			//SetCpuMode(ARM_MODE_UND);
			keyflag &= ~0x0200;
			break;
		case 'N':
			StepExecute();
			break;
		case 'R':
			OnReset();
			break;
		default:
			break;
		}
	}

	if(WM_KEYUP==pMsg->message){
		switch(pMsg->wParam){
		case 'Z':
			keyflag |= 0x0001;
			break;
		case 'X':
			keyflag |= 0x0002;
			break;
		case ' ':
			keyflag |= 0x0004;
			break;
		case VK_RETURN:
			keyflag |= 0x0008;
			break;
		case VK_RIGHT:
			keyflag |= 0x0010;
			break;
		case VK_LEFT:
			keyflag |= 0x0020;
			break;
		case VK_UP:
			keyflag |= 0x0040;
			break;
		case VK_DOWN:
			keyflag |= 0x0080;
			break;
		case 'S':
			keyflag |= 0x0100;
			break;
		case 'A':
			keyflag |= 0x0200;
			break;
		default:
			break;
		}
	}

	return CFrameWnd::PreTranslateMessage(pMsg);
}

void CMainFrame::UpdateDebugger()
{
	if(fRegisterDlg)m_pRegisterDlg->ShowRegister();
	if(fDisassemblerDlg){
		m_pDisassemblerDlg->ShowDisassembler_step(PC);
	}
	if(fMemoryDlg)m_pMemoryDlg->ShowMemory();
}

void CMainFrame::OnAutoUpdate() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(IDM_AUTO_UPDATE, MF_CHECKED)){
		GetMenu()->CheckMenuItem(IDM_AUTO_UPDATE, MF_UNCHECKED);
		fAutoUpdate = FALSE;
	}else{
		fAutoUpdate = TRUE;
	}
}

void CMainFrame::OnZoom1() 
{
	GetMenu()->CheckMenuRadioItem(IDM_ZOOM_1, IDM_ZOOM_FULLSCREEN, IDM_ZOOM_1, MF_BYCOMMAND);

	SetRect(&clientSize, 0, 0, LCD_X, LCD_Y);
	AdjustWindowRect(&clientSize, WS_OVERLAPPEDWINDOW, TRUE);
	SetWindowPos(&wndTop, 0, 0, clientSize.right - clientSize.left, 
							clientSize.bottom - clientSize.top, SWP_NOMOVE);
}

void CMainFrame::OnZoom2() 
{
	GetMenu()->CheckMenuRadioItem(IDM_ZOOM_1, IDM_ZOOM_FULLSCREEN, IDM_ZOOM_2, MF_BYCOMMAND);

	SetRect(&clientSize, 0, 0, LCD_X * 2, LCD_Y * 2);
	AdjustWindowRect(&clientSize, WS_OVERLAPPEDWINDOW, TRUE);
	SetWindowPos(&wndTop, 0, 0, clientSize.right - clientSize.left, 
							clientSize.bottom - clientSize.top, SWP_NOMOVE);
}

void CMainFrame::OnZoom3() 
{
	GetMenu()->CheckMenuRadioItem(IDM_ZOOM_1, IDM_ZOOM_FULLSCREEN, IDM_ZOOM_3, MF_BYCOMMAND);

	SetRect(&clientSize, 0, 0, LCD_X * 3, LCD_Y * 3);
	AdjustWindowRect(&clientSize, WS_OVERLAPPEDWINDOW, TRUE);
	SetWindowPos(&wndTop, 0, 0, clientSize.right - clientSize.left, 
							clientSize.bottom - clientSize.top, SWP_NOMOVE);
}

void CMainFrame::OnZoom4() 
{
	GetMenu()->CheckMenuRadioItem(IDM_ZOOM_1, IDM_ZOOM_FULLSCREEN, IDM_ZOOM_4, MF_BYCOMMAND);

	SetRect(&clientSize, 0, 0, LCD_X * 4, LCD_Y * 4);
	AdjustWindowRect(&clientSize, WS_OVERLAPPEDWINDOW, TRUE);
	SetWindowPos(&wndTop, 0, 0, clientSize.right - clientSize.left, 
							clientSize.bottom - clientSize.top, SWP_NOMOVE);
}

void CMainFrame::OnZoomFullscreen() 
{
	GetMenu()->CheckMenuRadioItem(IDM_ZOOM_1, IDM_ZOOM_FULLSCREEN, IDM_ZOOM_FULLSCREEN, MF_BYCOMMAND);

	PostMessage(WM_SYSCOMMAND, SC_MAXIMIZE);
}

void CMainFrame::OnTimer(UINT nIDEvent) 
{
	char str[50];

	if(fTMain){
		sprintf(str, _TITLE_" - %d%%", (int)(FrameCount/59.0f*100));
		FrameCount = 0;
	}else{
		sprintf(str, _TITLE_);
	}
	SetWindowText(str);

	CFrameWnd::OnTimer(nIDEvent);
}

void CMainFrame::OnShowFps() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(IDM_SHOW_FPS, MF_CHECKED)){
		GetMenu()->CheckMenuItem(IDM_SHOW_FPS, MF_UNCHECKED);
		fFps = FALSE;
		KillTimer(1);
		SetWindowText(_TITLE_);
	}else{
		fFps = TRUE;
		SetTimer(1, 1000, NULL);
	}
}

void CMainFrame::OnVsync() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(IDM_VSYNC, MF_CHECKED)){
		GetMenu()->CheckMenuItem(IDM_VSYNC, MF_UNCHECKED);
		fVsync = FALSE;
	}else{
		fVsync = TRUE;
	}
}

void CMainFrame::OnDropFiles(HDROP hDropInfo) 
{
	char filename[MAX_PATH];

	DragQueryFile(hDropInfo, 0, filename, sizeof(filename));
	DragFinish(hDropInfo);

	WaitForTMain();

	if(!AgbRomOpen(filename)){
		OnRun();
	}

	CFrameWnd::OnDropFiles(hDropInfo);
}

void CMainFrame::OnDestroy() 
{
	CFrameWnd::OnDestroy();
	
	CloseRomFile(Rom);
}

void CMainFrame::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CFrameWnd::OnActivate(nState, pWndOther, bMinimized);
	
	if(fNext){
		fNext = FALSE;
		StepExecute();
	}
}


void CMainFrame::OnInformation() 
{
	char str[512];

	ShowHeaderInfo(Rom, str);
	MessageBox(str, 0, 0);
}
