#include "stdafx.h"

#include "Crypt.hpp"

#include <assert.h>

#include <vector>



CCryptException::CCryptException(DWORD errorcode)
	: errorcode_(errorcode)
{
}

DWORD CCryptException::GetErrorCode() const
{
	return errorcode_;
}


//////////////////////////////////////////

CCrypt::CCrypt()
	: hProv_(0)
{
}

CCrypt::~CCrypt() throw()
{
	// voC_B
	if (hProv_) {
		::CryptReleaseContext(hProv_, 0);
		hProv_ = NULL;
	}
}

/*!
 * voC_܂B
 * łɏς݂łΉ܂B
 */
void CCrypt::init()
{
	if (hProv_) {
		// łɏς݂łΉȂB
		return;
	}

	// ÍvoC_̎擾
	// Windows98/200̂߂AESł͂ȂDESƂB
	// Win98̂߂CRYPT_VERIFYCONTEXTŔ閧L[̃L[XgAgpȂƂ𖾎B
	if ( !CryptAcquireContext(&hProv_, NULL, NULL, PROV_RSA_FULL, CRYPT_VERIFYCONTEXT)) {
		throw CCryptException(GetLastError());
	}

	// T|[gĂASŸꗗ̎擾
	loadSupportedAlgorithm();
}

/*!
 * T|[gĂASŸꗗ擾܂B
 */
void CCrypt::loadSupportedAlgorithm()
{
	assert(hProv_ && "voC_Ă܂B");

	algtypemap_.clear();

	PROV_ENUMALGS alginfo = {0};

	DWORD enumflg = CRYPT_FIRST;
	for (;;) {
		DWORD alginfosiz = sizeof(PROV_ENUMALGS);
		BOOL ret = CryptGetProvParam(
			hProv_,
			PP_ENUMALGS,
			(BYTE*) &alginfo,
			&alginfosiz,
			enumflg);

		if (!ret) {
			DWORD errorcode = GetLastError();
			if (errorcode == ERROR_NO_MORE_ITEMS) {
				break;
			}
			throw CCryptException(errorcode);
		}

		// ASYIDƖÕyAi[
		CA2T algName(alginfo.szName);
		algtypemap_.insert(algtype(alginfo.aiAlgid, tstring(algName)));

		enumflg = CRYPT_NEXT;
	}
}


const CCrypt::algtype& CCrypt::chooseAlgorithm()
{
	// 
	init();
	assert(hProv_ && "voC_Ă܂B");

	// D揇
	ALG_ID algidPriority[] = {CALG_3DES_112, CALG_3DES, CALG_DES, 0};
	
	ALG_ID *pAlg = algidPriority;
	while (*pAlg) {
		algtypemap::const_iterator ite = algtypemap_.find(*pAlg);
		if (ite != algtypemap_.end()) {
			return *ite;
		}
		pAlg++;
	}
	throw CCryptException(ERROR_INVALID_PARAMETER);
}

/*!
 * w肵ÖÍASYT|[gĂ钆擾B
 * YȂꍇ͗OB
 * \param ASY
 * \return ASY
 */
const CCrypt::algtype& CCrypt::findAlgorithm(const tstring& algName)
{
	// 
	init();
	assert(hProv_ && "voC_Ă܂B");

	for (algtypemap::const_iterator ite = algtypemap_.begin();
		ite != algtypemap_.end();
		++ite) {
		// OƈvÍASYTo
		if (ite->second == algName) {
			return *ite;
		}
	}
	throw CCryptException(ERROR_INVALID_PARAMETER);
}

void CCrypt::encrypt(const tstring& password, const algtype &algtyp, const tstring& src, tstring& result)
{
	if (password.empty()) {
		// pX[h̏ꍇ́Â܂ܕԂB
		result = src;
		return;
	}

	// 
	init();
	assert(hProv_ && "voC_Ă܂B");

	// pX[hx[X̑Ώ̃L[
	CCryptPassword passwordKey(*this);
	if ( !passwordKey.setPassword(algtyp, password)) {
		// ÍL[Ȃꍇ͕̂܂ܕԂ
		result = src;
		return;
	}
	assert(passwordKey.hPasswordKey_ && "ÍL[ݒ肳Ă܂B");

	// Íobt@Ƀ\[X]LB
	// (\[XłĂÍB)
	LPCTSTR szSrc = src.c_str();
	DWORD bytelen = static_cast<DWORD>(sizeof(TCHAR) * src.length());
	DWORD bufsiz = ((bytelen / 16) + 1) * 16; // 128bit block size
	
	std::vector<unsigned char> buf(bufsiz);
	memcpy(&buf[0], szSrc, bytelen);

	// Í
	if ( !CryptEncrypt(passwordKey.hPasswordKey_, NULL, TRUE, 0, &buf[0], &bytelen, bufsiz)) {
		throw CCryptException(GetLastError());
	}

	// Íʂ̐擪ɃASYݒ
	result.clear();
	result += _T("{{");
	result += algtyp.second;
	result += _T("}}");

	// Íʂ16iŕ\
	TCHAR szHex[10] = {0};
	for (int idx = 0; idx < (int) bytelen; idx++) {
		unsigned int ch = buf[idx];
		_stprintf_s(szHex, 10, _T("%02x"), ch);
		result += szHex;
	}
}

void CCrypt::decrypt(const tstring& password, const tstring& src, tstring& result)
{
	if (password.empty()) {
		// pX[h̏ꍇ́Â܂ܕԂB
		result = src;
		return;
	}
	if (src.empty()) {
		// \[Xsł΁Â܂ܕԂB
		result.clear();
		return;
	}

	tstring head = _T("{{");
	size_t endpt = src.npos;
	if (src.compare(0, head.length(), head) != 0
		|| (endpt = src.find(_T("}}"))) == src.npos) {
		// {{Ŏn܂ĂȂꍇA}}Ȃꍇ
		// ÍȂ̂ŕƂ݂ȂB
		result = src;
		return;
	}

	// 
	init();

	// ASYHEX̕
	tstring algName = src.substr(2, endpt - 2);
	tstring strHex = src.substr(endpt + 2);

	algtype algtyp = findAlgorithm(algName);

	// pX[hx[X̑Ώ̃L[̐
	CCryptPassword passwordKey(*this);
	if ( !passwordKey.setPassword(algtyp, password)) {
		// ÍL[Ȃ\[XÂ܂ܕԂB
		result = src;
		return;
	}
	assert(passwordKey.hPasswordKey_ && "ÍL[ݒ肳Ă܂B");

	// hexoCgɕϊ
	TCHAR szHex[3] = {0};

	std::vector<unsigned char> buf;

	LPCTSTR p = strHex.c_str();
	while (*p) {
		szHex[0] = *p++;
		szHex[1] = *p ? *p++ : 0;
		int byte = _tcstol(szHex, NULL, 16);
		buf.push_back((unsigned char) byte);
	}
	DWORD bytelen = static_cast<DWORD>(buf.size());

	// Í
	if ( !CryptDecrypt(passwordKey.hPasswordKey_, NULL, TRUE, 0, &buf[0], &bytelen)) {
		throw CCryptException(GetLastError());
	}

	// I[
	buf.push_back(0);
	buf[bytelen] = 0;
#ifdef _UNICODE
	buf.push_back(0);
	buf[bytelen + 1] = 0;
#endif

	// oCg񂩂當
	result.clear();
	result = tstring((LPCTSTR) &buf[0]);
}



///////////////////////////////////////////////////////


CCrypt::CCryptPassword::CCryptPassword(CCrypt &crypt)
	: crypt_(crypt)
	, hPasswordHash_(0)
	, hPasswordKey_(0)
{
}

CCrypt::CCryptPassword::~CCryptPassword() throw()
{
	// pX[hNAB
	clearPassword();
}

/*!
 * AvoC_̃nh擾܂B
 * łɏς݂ł΁ÃnhԂ܂B
 */
HCRYPTPROV CCrypt::CCryptPassword::init()
{
	crypt_.init();
	assert(crypt_.hProv_ && "ÍvoC_Ă܂B");
	return crypt_.hProv_;
}

/*!
 * pX[hݒ肵܂B
 * ̏ꍇ̓pX[h܂B
 */
bool CCrypt::CCryptPassword::setPassword(const CCrypt::algtype &algtyp, const tstring& password)
{
	// ĂȂΏB
	HCRYPTPROV hProv = init();

	// łɃpX[hݒς݂ł΃NAB
	clearPassword();

	if (password.empty()) {
		// pX[hł΁AnbVƃL[͕svB
		return false;
	}

	HCRYPTHASH hHash = NULL;
	HCRYPTKEY hKey= NULL;
	try {
		// nbV\zB
		hHash = createHash(hProv, password);

		// Ώ̈ÍL[𐶐B
		hKey = createKey(hProv, hHash, algtyp);
	}
	catch (...) {
		if (hKey) {
			::CryptDestroyKey(hKey);
		}
		if (hHash) {
			::CryptDestroyHash(hHash);
		}
		throw;
	}

	assert(hHash && "nbVnhݒ肳Ă܂B");
	assert(hKey && "ÍL[ݒ肳Ă܂B");

	hPasswordHash_ = hHash;
	hPasswordKey_ = hKey;
	algName_ = algtyp.second;

	return true;
}

/*!
 * pX[h܂B
 */
void CCrypt::CCryptPassword::clearPassword()
{
	if (hPasswordKey_) {
		::CryptDestroyKey(hPasswordKey_);
		hPasswordKey_ = NULL;
	}

	if (hPasswordHash_) {
		::CryptDestroyHash(hPasswordHash_);
		hPasswordHash_ = NULL;
	}
}

/*!
 * pX[hx[X̃nbV𐶐ĕԂ܂B
 * \param password pX[h
 * \return nbV
 */
HCRYPTHASH CCrypt::CCryptPassword::createHash(HCRYPTPROV hProv, const tstring& password)
{
	assert(hProv && "voC_Ă܂B");

	HCRYPTHASH hHash = 0;
	if ( !CryptCreateHash(hProv, CALG_SHA, 0, 0, &hHash)) {
		throw CCryptException(GetLastError());
	}
	try {
		LPCTSTR szPassword = password.c_str();
		DWORD bytelen = static_cast<DWORD>(sizeof(TCHAR) * password.length());
		if ( !CryptHashData(hHash, (const BYTE *) szPassword, bytelen, 0)) {
			throw CCryptException(GetLastError());
		}
	}
	catch (...) {
		::CryptDestroyHash(hHash);
		hHash = 0;
		throw;
	}

	return hHash;
}

/*!
 * nbVΏ̈ÍL[𐶐܂B
 * \param hHash nbV
 * \param alg ASY
 * \return ÍL[
 */
HCRYPTKEY CCrypt::CCryptPassword::createKey(HCRYPTPROV hProv, HCRYPTHASH hHash, const CCrypt::algtype &alg)
{
	assert(hProv && "voC_Ă܂B");
	assert(hHash && "nbVNULLłB");

	ALG_ID algid = alg.first;
	HCRYPTKEY hCryptKey = 0;
	if ( !CryptDeriveKey(hProv, algid, hHash, CRYPT_NO_SALT, &hCryptKey)) {
		throw CCryptException(GetLastError());
	}
	return hCryptKey;
}

