#pragma once

#include <string>
#include <map>


class StringExpander
{
private:
	bool unresolveEmpty_;

public:
	StringExpander();

	virtual ~StringExpander() throw() {}

	virtual tstring expandString(const tstring& v_template) const throw();

	void setUnresolveEmpty(const bool v_mode);

	inline bool isUnresolveEmpty() const
	{
		return unresolveEmpty_;
	}

protected:
	virtual tstring resolveParameter(const tstring& v_name, bool* v_pResolved) const throw() = 0;
};


class PropertyStringExpander : public StringExpander
{
protected:
	typedef std::map<tstring, tstring> PropertyMap;

	PropertyMap propertyMap_;

public:
	PropertyStringExpander() throw();

	PropertyStringExpander(const PropertyStringExpander& v_other) throw();

	PropertyStringExpander& operator=(const PropertyStringExpander& v_other) throw();

	virtual ~PropertyStringExpander() throw();

	virtual void addProperty(const tstring& v_name, const tstring& v_value) throw();

protected:
	virtual tstring resolveParameter(const tstring& v_name, bool* v_pFound) const throw();

	virtual tstring getKeyName(const tstring& v_name) const throw();

};
