#include "stdafx.h"

#include "NameMatcherImpl.hpp"
#include "ObjectLockUty.hpp"

using namespace FWatchCore2Lib;

////////////////////////////////////////////////////

HRESULT CSimpleNameMatcher::Init(LPCWSTR v_pPattern) throw()
{
	if ( !v_pPattern) {
		return E_INVALIDARG;
	}

	BSTR buf = NULL;

	if (lstrcmp(v_pPattern, L"*.*") != 0) {
		HRESULT hr = CreateComparableString(v_pPattern, &buf);
		if (FAILED(hr)) {
			return hr;
		}
	}
	else {
		// *.**Ɠ`ƂB
		buf = SysAllocString(L"*");
		if ( !buf) {
			return E_OUTOFMEMORY;
		}
	}

	ATLASSERT(buf);

	pattern_.Attach(buf);

	return S_OK;
}

HRESULT __stdcall CSimpleNameMatcher::IsMatch(LPCWSTR v_pName) throw()
{
	if ( !v_pName) {
		return S_FALSE;
	}

	CComBSTR buf;
	HRESULT hr = CreateComparableString(v_pName, &buf);
	if (FAILED(hr)) {
		return hr;
	}

	return IsMatch(buf, pattern_);
}

/**
 * rpɑ啶ɑĕԂ܂B
 * @param v_pName 
 * @param v_pBuf ϊꂽi[BSTR̃|C^
 * @return ܂͎s\HRESULT
 */
HRESULT CSimpleNameMatcher::CreateComparableString(LPCWSTR v_pName, BSTR* v_pBuf) throw()
{
	ATLASSERT(v_pBuf && v_pName);

	const DWORD flag = LCMAP_UPPERCASE;
	const int nameLen = lstrlen(v_pName);

	const int needLen = LCMapString(GetUserDefaultLCID(), flag, v_pName, nameLen, NULL, 0 );
	if ( !needLen) {
		return AtlHresultFromLastError();
	}
	
	BSTR buf = SysAllocStringLen(NULL, needLen);
	if (!buf) {
		return E_OUTOFMEMORY;
	}
	CComBSTR guard;
	guard.Attach(buf);

	const int result = LCMapString(GetUserDefaultLCID(), flag, v_pName, nameLen, buf, needLen);
	if ( !result) {
		return AtlHresultFromLastError();
	}

	ATLASSERT(buf);
	*v_pBuf = SysAllocString(buf);

	return S_OK;
}

/**
 * 2̕r܂B
 * p^[́u*vu?ṽChJ[h󂯓܂B
 * @param v_pName rΏ
 * @param v_pPattern p^[
 * @return }b`S_OKA}b`ȂS_FALSEAG[Ȃ΃G[R[h
 */
HRESULT CSimpleNameMatcher::IsMatch(LPCWSTR v_pName, LPCWSTR v_pPattern) throw()
{
	ATLASSERT(v_pName && v_pPattern);

	LPCWSTR pPattern = v_pPattern;
	LPCWSTR pName = v_pName;

	for (;;) {
		if ( !*pPattern) {
			return (*pPattern == *pName) ? S_OK : S_FALSE;
		}
		
		if (*pPattern == '?') {
			pPattern += 1;
			// I[ƃhbg܂ޔCӂ1Ƀ}b`
			if (*pName && *pName != '.') {
				pName += 1;
			}
		}
		else if (*pPattern == '*') {
			// I[܂ޕɃ}b`
			pPattern += 1;
			if ( !*pPattern) {
				return S_OK;
			}
			while (*pName) {
				if (*pName == *pPattern) {
					if (IsMatch(pName, pPattern) == S_OK) {
						return S_OK;
					}
				}
				pName += 1;
			}
			// }b`p^[Ȃ
			return S_FALSE;
		}
		else {
			if (*pPattern != *pName) {
				return S_FALSE;
			}
			pPattern += 1;
			if (*pName) {
				pName += 1;
			}
		}
	}
}

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CSimpleNameMatcher), CSimpleNameMatcher)

////////////////////////////////////////////////////

HRESULT CMultiNameMatcher::FinalConstruct() throw()
{
	matchingMode_ = MULTI_NAME_MATCH_OR;

	return S_OK;
}

HRESULT __stdcall CMultiNameMatcher::AppendNameMatcher(INameMatcher* v_pNameMatcher) throw()
{
	if ( !v_pNameMatcher) {
		return E_INVALIDARG;
	}

	ThreadGuard<CMultiNameMatcher> lock(this);

	try {
		matcherList_.Add(v_pNameMatcher);
	}
	catch (...) {
		return E_OUTOFMEMORY;
	}

	return S_OK;
}

HRESULT __stdcall CMultiNameMatcher::set_MatchingMode(MULTI_NAME_MATCH_MODE v_mode) throw()
{
	if (v_mode & ~MULTI_NAME_MATCH_NAND) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ThreadGuard<CMultiNameMatcher> lock(this);

	matchingMode_ = v_mode;

	return S_OK;
}

HRESULT __stdcall CMultiNameMatcher::get_MatchingMode(MULTI_NAME_MATCH_MODE* v_pMode) throw()
{
	if ( !v_pMode) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ThreadGuard<CMultiNameMatcher> lock(this);

	*v_pMode = matchingMode_;

	return S_OK;
}

HRESULT __stdcall CMultiNameMatcher::IsMatch(LPCWSTR v_pName) throw()
{
	ThreadGuard<CMultiNameMatcher> lock(this);

	bool result = (matchingMode_ & MULTI_NAME_MATCH_AND) ? true : false;

	const size_t cnt = matcherList_.GetCount();
	for (size_t idx = 0; idx < cnt; idx++) {
		INameMatcher* pMatcher = matcherList_.GetAt(idx);
		ATLASSERT(pMatcher);
		HRESULT hr = pMatcher->IsMatch(v_pName);
		if (FAILED(hr)) {
			return hr;
		}
		
		if (matchingMode_ & MULTI_NAME_MATCH_AND) {
			if (hr == S_FALSE) {
				result = false;
				break;
			}
		}
		else {
			if (hr == S_OK) {
				result = true;
				break;
			}
		}
	}

	if (matchingMode_ & MULTI_NAME_MATCH_NOT) {
		result = !result;
	}

	return result ? S_OK : S_FALSE;
}

OBJECT_ENTRY_NON_CREATEABLE_EX_AUTO(__uuidof(CMultiNameMatcher), CMultiNameMatcher)

extern "C" HRESULT __stdcall CreateMultiNameMatcherObject(IMultiNameMatcher** v_ppMultiNameMatcher) throw()
{
	if ( !v_ppMultiNameMatcher) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}
	
	return CMultiNameMatcher::CreateInstance(v_ppMultiNameMatcher);
}

///////////////////////////////////////////////////

HRESULT CNameMatcherFactory::Create0(LPCWSTR v_pNamePattern, IMultiNameMatcher** v_ppNameMatcher) throw()
{
	ATLASSERT(v_ppNameMatcher);

	ATLASSERT(!*v_ppNameMatcher);
	*v_ppNameMatcher = NULL;

	HRESULT hr;

	CComPtr<IMultiNameMatcher> pMatcherList;
	hr = CMultiNameMatcher::CreateInstance(&pMatcherList);
	if (FAILED(hr)) {
		return hr;
	}

	if (v_pNamePattern) {
		LPCWSTR p = v_pNamePattern;
		LPCWSTR s = p;
		for(;;) {
			if (!*p || *p == ';') {
				const int len = static_cast<int>(p - s);
				if (len > 0) {
					CComBSTR token(len, s);

					CComObject<CSimpleNameMatcher>* pMatcher = NULL;
					hr = CComObject<CSimpleNameMatcher>::CreateInstance(&pMatcher);
					if (FAILED(hr)) {
						return hr;
					}
					ATLASSERT(pMatcher);
					CComPtr<INameMatcher> guard2(pMatcher);

					hr = pMatcher->Init(token);
					if (FAILED(hr)) {
						return hr;
					}

					hr = pMatcherList->AppendNameMatcher(pMatcher);
					if (FAILED(hr)) {
						return hr;
					}
				}

				if (!*p) {
					break;
				}
				p += 1;
				s = p;
			}
			else {
				p += 1;
			}
		}
	}

	ATLASSERT(pMatcherList);
	return pMatcherList.QueryInterface(v_ppNameMatcher);
}

HRESULT __stdcall CNameMatcherFactory::Create(LPCWSTR v_pNamePattern, INameMatcher** v_ppNameMatcher) throw()
{
	if ( !v_ppNameMatcher) {
		return E_INVALIDARG;
	}

	ATLASSERT(!*v_ppNameMatcher);
	*v_ppNameMatcher = NULL;

	CComPtr<IMultiNameMatcher> pMultiNameMatcher;
	HRESULT hr = Create0(v_pNamePattern, &pMultiNameMatcher);
	if (FAILED(hr)) {
		return hr;
	}

	ATLASSERT(pMultiNameMatcher);
	return pMultiNameMatcher.QueryInterface(v_ppNameMatcher);
}

HRESULT __stdcall CNameMatcherFactory::CreateDeny(LPCWSTR v_pNamePattern, INameMatcher** v_ppNameMatcher) throw()
{
	if ( !v_ppNameMatcher) {
		return E_INVALIDARG;
	}

	ATLASSERT(!*v_ppNameMatcher);
	*v_ppNameMatcher = NULL;

	CComPtr<IMultiNameMatcher> pMultiNameMatcher;
	HRESULT hr = Create0(v_pNamePattern, &pMultiNameMatcher);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pMultiNameMatcher);

	hr = pMultiNameMatcher->set_MatchingMode(MULTI_NAME_MATCH_NOR);
	if (FAILED(hr)) {
		return hr;
	}
	ATLASSERT(pMultiNameMatcher);

	return pMultiNameMatcher.QueryInterface(v_ppNameMatcher);
}

HRESULT __stdcall CNameMatcherFactory::CreateAcceptDeny(LPCWSTR v_pAcceptNamePattern, LPCWSTR v_pDenyNamePattern, INameMatcher** v_ppNameMatcher) throw()
{
	if ( !v_ppNameMatcher) {
		ATLASSERT(false);
		return E_INVALIDARG;
	}

	ATLASSERT(!*v_ppNameMatcher);
	*v_ppNameMatcher = NULL;

	HRESULT hr;

	CComPtr<IMultiNameMatcher> pMultiMatcher;
	hr = CMultiNameMatcher::CreateInstance(&pMultiMatcher);
	if (FAILED(hr)) {
		return hr;
	}

	hr = pMultiMatcher->set_MatchingMode(MULTI_NAME_MATCH_AND);
	if (FAILED(hr)) {
		return hr;
	}

	CComPtr<INameMatcher> pAcceptMatcher;
	if (v_pAcceptNamePattern) {
		hr = Create(v_pAcceptNamePattern, &pAcceptMatcher);
		if (SUCCEEDED(hr)) {
			hr = pMultiMatcher->AppendNameMatcher(pAcceptMatcher);
		}
		if (FAILED(hr)) {
			return hr;
		}
	}

	CComPtr<INameMatcher> pDenyMatcher;
	if (v_pDenyNamePattern) {
		hr = CreateDeny(v_pDenyNamePattern, &pDenyMatcher);
		if (SUCCEEDED(hr)) {
			hr = pMultiMatcher->AppendNameMatcher(pDenyMatcher);
		}
		if (FAILED(hr)) {
			return hr;
		}
	}

	ATLASSERT(pMultiMatcher);
	return pMultiMatcher.QueryInterface(v_ppNameMatcher);
}

OBJECT_ENTRY_AUTO(__uuidof(CNameMatcherFactory), CNameMatcherFactory)

///////////////////////////////////////////////////

extern "C" HRESULT __stdcall CreateNameMatcherFactoryObject(INameMatcherFactory** v_ppNameMatcherFactory) throw()
{
	if ( !v_ppNameMatcherFactory) {
		return E_INVALIDARG;
	}

	return CNameMatcherFactory::CreateInstance(v_ppNameMatcherFactory);
}
