#pragma once

struct HRESULT_TRANSFORM
{
	HRESULT targetCode;
	HRESULT mask;
	HRESULT resultCode;
};

typedef CAtlList<HRESULT_TRANSFORM> TransformMappingList;

class __declspec(uuid("9F394770-B522-448e-8AA5-9E49844AD0D0")) CErrorTransformerFactory
	: public IErrorTransformerFactory
	, public CComObjectRoot
	, public CComCoClass<CErrorTransformerFactory>
{
public:
	DECLARE_OBJECT_DESCRIPTION("CErrorTransformerFactory")
	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	BEGIN_COM_MAP(CErrorTransformerFactory)
		COM_INTERFACE_ENTRY(IErrorTransformerFactory)
	END_COM_MAP()

	/// IErrorTransformFactory

	HRESULT __stdcall Clear(void) throw();

	HRESULT __stdcall TransformErrorCode(HRESULT v_errorCode, HRESULT v_transformedErrorCode) throw();

	HRESULT __stdcall Create(IErrorHandler* v_pChainHandler, IErrorHandler** v_ppErrorTransformer) throw();

private:

	TransformMappingList errorCodeMapping_;
};

class __declspec(uuid("6867C74F-4348-4fe8-8A71-54F6F240524E")) CErrorTransformer
	: public IErrorHandler
	, public CComObjectRoot
	, public CComCoClass<CErrorTransformer>
{
public:
	DECLARE_OBJECT_DESCRIPTION("CErrorTransformer")
	DECLARE_CLASSFACTORY()
	DECLARE_NO_REGISTRY()

	BEGIN_COM_MAP(CErrorTransformer)
		COM_INTERFACE_ENTRY(IErrorHandler)
	END_COM_MAP()

	/// PRIVATE

	HRESULT Init(IErrorHandler* v_pChainHandler, TransformMappingList& v_mappingList) throw();

	/// IErrorHandler

	HRESULT __stdcall HandleError(HRESULT v_errorCode) throw();

private:
	CComPtr<IErrorHandler> pChainHandler_;
	TransformMappingList errorCodeMapping_;
};

