package com.ftinc.si.assist.test.web;

import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JTextArea;

public class StatusViewer extends JFrame {

	private SecondaryLoop subloop = null;
	private JTextArea textArea = null;
	
	public StatusViewer() {
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				if (subloop != null) {
					//subloopがある場合、exitする。
					subloop.exit();
				}
			}
		});
		setBounds(100, 100, 720, 83);
		getContentPane().setLayout(null);
		
		textArea = new JTextArea();
		textArea.setBounds(0, 0, 704, 41);
		getContentPane().add(textArea);
	}
	
	//TestCaseごとにWindowをリフレッシュする。
	public void update(String msg) {
		Toolkit tk = Toolkit.getDefaultToolkit();
		EventQueue eq = tk.getSystemEventQueue();
		subloop = eq.createSecondaryLoop();
		
		//表示をセットする。
		textArea.setText(msg);
		
		//このスレッドで抜ける。その間に画面を更新する。
		Thread t_thread = new ShortThread();
		t_thread.start();
		
		//スレッドでexitするまでループする。
		subloop.enter();
	}
	
	
/*	//displaymodeで最後にWindowを開いたまま待つ。
	public void subLoop() {
		//閉じるまで待つ場合。
		Toolkit tk = Toolkit.getDefaultToolkit();
		EventQueue eq = tk.getSystemEventQueue();
		subloop = eq.createSecondaryLoop();
		
		//閉じるボタンが押されるまでループする。
		subloop.enter();
	}
*/	
	class ShortThread extends Thread {
		@Override
		public void run() {
			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {
				//気にしない。
			}
			subloop.exit();
		}
	}
}
