package com.ftinc.si.assist.test.gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.Tool;

public class AssertStatusWindow extends JFrame {
	private JTextField curStatus;
	private JTextArea failLogs;
	private Integer n_test = 0;
	private Integer n_fail = 0;
	private Integer n_err = 0;
	public boolean ifexit = false; //close&ExitMode:true(閉じるまで待つ)、close&ContMode:false.
	
	private SecondaryLoop subloop = null;
	
	public AssertStatusWindow() {
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				if (ifexit) {
					if (subloop != null) {
						//subloopがある場合、exitする。
						subloop.exit();
					}
					Tool.destroy();
				}
			}
		});
		setResizable(false);
		setTitle(Messages.getString("AssertStatusWisndow.0") + "  (Copyright:Toyoaki Furusawa, 2017-)"); //$NON-NLS-1$
		getContentPane().setLayout(null);
		setAlwaysOnTop(true);
		if (TestCaseBrowser.s_curFrame == null) {
			//TestCaseBrowserがないということは、プロセスモード。
			setBounds(100, 100, 720, 300);
		} else {
			setBounds(TestCaseBrowser.s_curFrame.getX() + 100, TestCaseBrowser.s_curFrame.getY() + 100, 720, 300);
		}
		
		curStatus = new JTextField();
		curStatus.setBounds(12, 32, 690, 19);
		getContentPane().add(curStatus);
		curStatus.setColumns(10);
		curStatus.setForeground(Color.WHITE);
		
		JLabel lblStatusOfCurrent = new JLabel(Messages.getString("AssertStatusWindow.1")); //$NON-NLS-1$
		lblStatusOfCurrent.setBounds(12, 9, 196, 13);
		getContentPane().add(lblStatusOfCurrent);
		
		JLabel lblFailHistory = new JLabel(Messages.getString("AssertStatusWindow.2")); //$NON-NLS-1$
		lblFailHistory.setBounds(12, 61, 115, 13);
		getContentPane().add(lblFailHistory);
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(12, 82, 690, 169);
		getContentPane().add(scrollPane);
		
		failLogs = new JTextArea();
		scrollPane.setViewportView(failLogs);
	}
	
	public void setResult(String res) {
		if (res != null) {
			final Pattern t_pat1 = Pattern.compile("testsuite.*?tests=\"([^\"]+?)\".*?errors=\"([^\"]+?)\".*?failures=\"([^\"]+?)\""); //$NON-NLS-1$
			Matcher t_m = t_pat1.matcher(res);
			
			n_test = 0;
			n_err = 0;
			n_fail = 0;
			while (t_m.find()) {
				String num_tests = t_m.group(1);
				String num_errs = t_m.group(2);
				String num_fails = t_m.group(3);
				
				n_test += new Integer(num_tests);
				n_err += new Integer(num_errs);
				n_fail += new Integer(num_fails);
			}
			
			if (n_err + n_fail == 0) {
				//NGが全くないならGreenのまま。
				curStatus.setBackground(Color.GREEN);
			} else {
				curStatus.setBackground(Color.RED);
			}
			curStatus.setText("tests(" + Integer.toString(n_test) + ")  ERR(" + n_err.toString() + ")  FAIL(" + n_fail.toString() + Messages.getString("AssertStatusWindow.3")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		}
		failLogs.setText(res); //二重に書かない。
		
		//画面更新する。
		updateWindow();
	}
	
	//TestCaseごとにWindowをリフレッシュする。
	public void updateWindow() {
		Toolkit tk = Toolkit.getDefaultToolkit();
		EventQueue eq = tk.getSystemEventQueue();
		subloop = eq.createSecondaryLoop();
		
		//このスレッドで抜ける。その間に画面を更新する。
		Thread t_thread = new ShortThread();
		t_thread.start();
		
		//スレッドでexitするまでループする。
		subloop.enter();
	}
	
	
	//displaymodeで最後にWindowを開いたまま待つ。
	public void subLoop() {
		//displaymodeで、待つ場合にはsubloopを作る。
		if (ifexit) {
			//閉じるまで待つ場合。
			Toolkit tk = Toolkit.getDefaultToolkit();
			EventQueue eq = tk.getSystemEventQueue();
			subloop = eq.createSecondaryLoop();
			
			//閉じるボタンが押されるまでループする。
			subloop.enter();
		}
	}
	
	class ShortThread extends Thread {
		@Override
		public void run() {
			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {
				//気にしない。
			}
			subloop.exit();
		}
	}
}
