package com.ftinc.si.assist.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Record {
	int m_status; // 0:notchanged  1:updated  2:new
	public boolean enable = true;
	public boolean removed = false;
	
	public Record(int i) {
		m_status = i;
	}
	
	//DBの結果を読み込む。Tableの変更の影響を局所化するために、ここに設ける。
	public void read(ResultSet r) throws SQLException {
	}
	
	public void changed() {
		if (m_status < 2) {
			m_status = 1;
		}
	}
	
	public void saved() {
		m_status = 0;
	}
	
	public boolean isNew() {
		if (m_status == 2) {
			return true;
		}
		return false;
	}
	
	public boolean isUpdated() {
		if (m_status > 0) {
			return true;
		}
		return false;
	}
	
	public boolean isUnread() {
		if (m_status < 0) {
			return true;
		}
		return false;
	}

	public String getUpdateSQL() {
		return null;
	}
	
	public boolean getEnable() {
		return enable;
	}
	
	public void setEnable(boolean b) {
		enable = b;
	}
	
	//SQLの特殊文字（登録更新時）をエスケープ
	protected String esq(String str) {
		if (str != null) {
			String t_str = str.replaceAll(Pattern.quote("'"), Matcher.quoteReplacement("''"));
			return t_str;
		}
		return "";
	}
}
