//*****************************************************************************//
//fgraph.h
//Copyright (C) 2006 K.Tsuchiya all rights reserved.
//2006/08/29
//... fridge object relation graph.
//*****************************************************************************//
#ifndef __FGRTL_HEAD
#define __FGRTL_HEAD
#ifndef USECIOMEM
#define USECIOMEM /*use cio malloc*/
#endif
#include "calg.h"
//_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_

                       /**** fridge object define ****/

//_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_
/*fridge data type*/
enum __fgDataType{
    fgDataTypeInt, //int
    fgDataTypeFlt, //float
    fgDataTypeStr, //string
    fgDataTypeObj, //object
    fgDataTypeSize,//...data type struct size
};
/*fridge data element*/
typedef union{
    int    i;//integer element
    char*  s;//string  element
    double f;//float   element
}fgDataElm;
/*fridge data stuct*/
typedef struct{
    int type;      //data type
    fgDataElm elm; //data element
}fgData;
/*fridge object handle*/
typedef struct{
    char*   name;//file name
    int     size;//map size;
    cStack  gbg; //garbage ID list for 'obj'(vecotr<int>)
    cMap    obj; //object map(map<int,fgObj>)
    cMsg    msg; //fridge message
    cQueue  inq; //input  queue
    cQueue  outq;//output queue
    cMap    ntbl;//name table
    cVector nlst;//name list
    cMap    ktbl;//keyword table
    fgData  (*ask)(void*,char*,int);//ask function
}FG_HANDLE;
typedef FG_HANDLE* fgHandle;
/*fridge object*/
typedef struct _fgObj{
   char*   name; //instans name
   cMap    map;     //value map(map<string,fgData>)
   fgData (*meth)(fgHandle,int);//instance method 
}fgObj;

/*function define*/
extern int fgAskSet(fgHandle fhdl,fgData (*func)(fgHandle,char*,int));
extern fgData fgAskDef(fgHandle fhdl,char*name,int super);
extern int fgMakeObj(fgHandle fhdl,char*insname,int super);
extern int fgDelObj(fgHandle fhdl,int index);
extern fgData fgSetObj(fgHandle fhdl,int index,char*elmname,fgData data);
extern fgData fgGetObj(fgHandle fhdl,int index,char*elmname);
extern fgHandle fgGraphIni(char*name);
extern fgHandle fgGraphDes(fgHandle fhdl);
extern fgData fgMethDef(fgHandle fhdl,int index);
extern char* fgGraphGetName(fgHandle fhdl,char*name);
extern fgData fgMethod(fgHandle fhdl,int index);
extern int fgSetMeth(fgHandle fhdl,int index,
    fgData (*meth)(fgHandle,int));
extern char* fgGetName(fgHandle fhdl,int index);
extern char* fgPath(char*name,int flg,int*type);
extern int fgSysObjFileObj(char*name,char*path);
#define fgGetType(data)   (data.type)
#define fgGetValInt(data) (data.elm.i)
#define fgGetValFlt(data) (data.elm.f)
#define fgGetValStr(data) (data.elm.s)
#define fgGetValObj(data) (data.elm.i)
#define fgSetType(data,val)   (data.type=val)
#define fgSetValInt(data,val) (data.elm.i=val)
#define fgSetValFlt(data,val) (data.elm.f=val)
#define fgSetValStr(data,val) (data.elm.s=val)
#define fgSetValObj(data,val) (data.elm.i=val)

static inline fgData fgSetValTypeInt(int val){
   fgData data;
   fgSetType(data,fgDataTypeInt);
   fgSetValInt(data,val);
   return data;
}
static inline fgData fgSetValTypeFlt(double val){
   fgData data;
   fgSetType(data,fgDataTypeFlt);
   fgSetValFlt(data,val);
   return data;
}
static inline fgData fgSetValTypeStr(char* val){
   fgData data;
   fgSetType(data,fgDataTypeStr);
   fgSetValStr(data,val);
   return data;
}
static inline fgData fgSetValTypeObj(int val){
   fgData data;
   fgSetType(data,fgDataTypeObj);
   fgSetValObj(data,val);
   return data;
}
#endif


