/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.swing;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.swing.TaskListTable;

public class TaskListRootPane
extends JScrollPane {
    private static final long serialVersionUID = 1618049203954194983L;
    Application app;
    TaskListTable taskListTable;

    public TaskListRootPane(Application app) {
        super(22, 32);
        this.app = app;
        this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.taskListTable = new TaskListTable(app);
        this.taskListTable.setBounds(0, 0, 300, 400);
        this.taskListTable.setFillsViewportHeight(true);
        this.taskListTable.setPreferredScrollableViewportSize(new Dimension(1000, 1000));
        this.setViewportView(this.taskListTable);
        JTableHeader header = this.taskListTable.getTableHeader();
        header.setPreferredSize(new Dimension(1, 32));
        this.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport dataViewport = TaskListRootPane.this.app.getDataViewport();
                Point newViewPosition = TaskListRootPane.this.getViewport().getViewPosition();
                Point currentViewPosition = dataViewport.getViewPosition();
                dataViewport.setViewPosition(new Point(currentViewPosition.x, newViewPosition.y));
            }
        });
    }

    public TaskListTable getTaskListTable() {
        return this.taskListTable;
    }
}

