/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import jp.sourceforge.freegantt.swing.Application;
import jp.sourceforge.freegantt.util.GraphicsUtil;

public class GanttChartPrintable
implements Printable,
Pageable {
    Application app;
    Color borderColor = new Color(48, 48, 48);

    public static PageFormat getDefaultPageFormat() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pageFormat = job.defaultPage();
        pageFormat.setOrientation(0);
        return pageFormat;
    }

    public GanttChartPrintable(Application app) {
        this.app = app;
    }

    @Override
    public int getNumberOfPages() {
        return this.app.getTaskLineDataPane().getPrintRange().getPrintRanges().size();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.app.getProject().getPrint().getPageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        List<Rectangle> ranges = this.app.getTaskLineDataPane().getPrintRange().getPrintRanges();
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        if (pageIndex < ranges.size()) {
            Rectangle range = ranges.get(pageIndex);
            int titleHeight = this.app.getTaskLineDataPane().getCellHeight();
            int headerHeight = this.app.getTaskListTable().getTableHeader().getHeight();
            int taskListWidth = this.app.getTaskListTable().getWidth();
            int taskListHeight = this.app.getTaskListTable().getHeight();
            int imageWidth = taskListWidth + range.width;
            int imageHeight = titleHeight + headerHeight + range.height;
            double scaleX = pageFormat.getImageableWidth() / (double)imageWidth;
            double scaleY = pageFormat.getImageableHeight() / (double)imageHeight;
            double scale = Math.min(scaleX, scaleY);
            AffineTransform transform = g2d.getTransform();
            transform.scale(scale, scale);
            g2d.setTransform(transform);
            StringBuilder title = new StringBuilder();
            title.append(this.app.getProject().getName());
            if (ranges.size() > 1) {
                title.append(" (" + (pageIndex + 1) + "/" + ranges.size() + ")");
            }
            GraphicsUtil.drawStringLeft(g2d, title.toString(), 0, 0, 1, titleHeight);
            g2d.translate(1, titleHeight);
            Shape oldClip = g2d.getClip();
            g2d.setClip(new Rectangle(0, 0, taskListWidth, taskListHeight));
            this.app.getTaskListTable().getTableHeader().print(g2d);
            g2d.setClip(oldClip);
            g2d.translate(0, headerHeight);
            g2d.translate(0, -range.y);
            oldClip = g2d.getClip();
            g2d.setClip(new Rectangle(0, range.y, taskListWidth, range.height));
            this.app.getTaskListTable().print(g2d);
            g2d.setClip(oldClip);
            g2d.translate(0, range.y);
            g2d.translate(0, -headerHeight);
            g2d.translate(taskListWidth, 0);
            g2d.translate(-range.x, 0);
            oldClip = g2d.getClip();
            g2d.setClip(new Rectangle(range.x, 0, range.width, headerHeight));
            this.app.getTaskLineHeaderPane().paint(g2d);
            g2d.setClip(oldClip);
            g2d.translate(range.x, 0);
            g2d.translate(-taskListWidth, 0);
            g2d.translate(taskListWidth, headerHeight);
            boolean oldPrintRangeMode = this.app.getTaskLineDataPane().isPrintRangeMode();
            this.app.getTaskLineDataPane().setPrintRangeMode(false);
            g2d.translate(-range.x, -range.y);
            oldClip = g2d.getClip();
            g2d.setClip(new Rectangle(range.x, range.y, range.width, range.height));
            this.app.getTaskLineDataPane().paint(g2d);
            g2d.setClip(oldClip);
            g2d.translate(range.x, range.y);
            this.app.getTaskLineDataPane().setPrintRangeMode(oldPrintRangeMode);
            g2d.translate(-taskListWidth, -headerHeight);
            oldClip = g2d.getClip();
            g2d.setClip(0, 0, taskListWidth + range.width, headerHeight + range.height);
            GraphicsUtil.drawRect(g2d, 0, 0, taskListWidth + range.width - 1, headerHeight + range.height - 1);
            g2d.setClip(oldClip);
            return 0;
        }
        return 1;
    }
}

