/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class UpdateTaskEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -4925123071826232873L;
    Project project;
    int row;
    Task oldTask;
    Task newTask;

    public UpdateTaskEdit(Project project, Task newTask, int row) {
        this.project = project;
        this.row = row;
        this.oldTask = project.getTaskAtRow(row).clone();
        this.newTask = newTask.clone();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.project.getController().setTaskAtRow(this.oldTask, this.row);
        this.project.update();
        this.project.getTaskTableModel().fireTableChanged();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.project.getController().setTaskAtRow(this.newTask, this.row);
        this.project.update();
        this.project.getTaskTableModel().fireTableChanged();
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
        this.oldTask = null;
        this.newTask = null;
    }
}

