/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class RemoveRestrictioinEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 4876365331030618017L;
    Project project;
    int srcRow;
    int dstRow;

    public RemoveRestrictioinEdit(Project project, int srcRow, int dstRow) {
        this.project = project;
        this.srcRow = srcRow;
        this.dstRow = dstRow;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        Task srcTask = this.project.getTaskAtRow(this.srcRow);
        Task dstTask = this.project.getTaskAtRow(this.dstRow);
        srcTask.getRestrictions().add(dstTask);
        this.project.update();
        this.project.getTaskTableModel().fireTableChanged();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        Task srcTask = this.project.getTaskAtRow(this.srcRow);
        Task dstTask = this.project.getTaskAtRow(this.dstRow);
        srcTask.getRestrictions().remove(dstTask);
        this.project.update();
        this.project.getTaskTableModel().fireTableChanged();
    }

    @Override
    public void die() {
        super.die();
        this.project = null;
    }
}

